/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.geosparql;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.pfunction.PFuncSimpleAndList;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.sedona.common.Functions;
import org.locationtech.jts.geom.Geometry;

public class H3GeometryToCellIDsPF
extends PFuncSimpleAndList {
    private static final int GEOM_POS = 0;
    private static final int LEVEL_POS = 1;
    private static final int FULL_COVER_POS = 2;

    public QueryIterator execEvaluated(Binding binding, Node subject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        List objectArgs = argObject.getArgList();
        if (objectArgs.size() != 3) {
            throw new ExprEvalException(FmtUtils.stringForNode((Node)predicate) + ": 3 arguments required: geometry, level of resolution, full cover of polygon");
        }
        if (!subject.isVariable()) {
            throw new ExprEvalException(FmtUtils.stringForNode((Node)predicate) + ": subject must be variable.");
        }
        Var s = Var.alloc((Node)subject);
        Node geomLit = argObject.getArg(0);
        Node levelNode = argObject.getArg(1);
        NodeValue levelNodeVal = NodeValue.makeNode((Node)levelNode);
        if (!levelNodeVal.isInteger()) {
            throw new ExprEvalException("\"level of resolution\" argument not an integer: " + FmtUtils.stringForNode((Node)levelNodeVal.asNode()));
        }
        int level = levelNodeVal.getInteger().intValue();
        Node fullCoverNode = argObject.getArg(2);
        NodeValue fullCoverNodeVal = NodeValue.makeNode((Node)fullCoverNode);
        if (!fullCoverNodeVal.isBoolean()) {
            throw new ExprEvalException("\"full cover\" flag not a boolean: " + FmtUtils.stringForNode((Node)fullCoverNodeVal.asNode()));
        }
        boolean fullCover = fullCoverNodeVal.getBoolean();
        GeometryWrapper geomWrapper = GeometryWrapper.extract((Node)geomLit);
        Long[] ids = Functions.h3CellIDs((Geometry)geomWrapper.getParsingGeometry(), (int)level, (boolean)fullCover);
        Iterator iterator = Arrays.stream(ids).map(NodeFactoryExtra::intToNode).map(node -> BindingFactory.binding((Binding)binding, (Var)s, (Node)node)).iterator();
        return QueryIterPlainWrapper.create(iterator, (ExecutionContext)execCxt);
    }
}

