/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.distinct;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jena.atlas.data.BagFactory;
import org.apache.jena.atlas.data.DistinctDataBag;
import org.apache.jena.atlas.data.SerializationFactory;
import org.apache.jena.atlas.data.ThresholdPolicy;
import org.apache.jena.atlas.data.ThresholdPolicyFactory;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingComparator;
import org.apache.jena.sparql.engine.binding.BindingProjectNamed;
import org.apache.jena.sparql.engine.iterator.QueryIter1;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.system.SerializationFactoryFinder;
import org.apache.jena.sparql.util.Context;

public class QueryIterDistinctConditional
extends QueryIter1 {
    private long memThreshold = Long.MAX_VALUE;
    private Binding slot = null;
    private final List<SortCondition> preserveOrder;
    private Iterator<Binding> iterator = null;
    private Collection<Bucket> buckets;

    public QueryIterDistinctConditional(QueryIterator qIter, List<SortCondition> preserveOrder, ExecutionContext execCxt, Collection<ExprList> conditions) {
        super(qIter, execCxt);
        List<Object> list = this.preserveOrder = preserveOrder != null ? preserveOrder : Collections.emptyList();
        if (execCxt != null) {
            this.memThreshold = execCxt.getContext().getLong(ARQ.spillToDiskThreshold, this.memThreshold);
            if (this.memThreshold < 0L) {
                throw new ARQException("Bad spillToDiskThreshold: " + this.memThreshold);
            }
        }
        this.buckets = conditions.stream().map(x$0 -> new Bucket((ExprList)x$0)).collect(Collectors.toList());
    }

    public Bucket getBucket(Binding b) {
        Bucket result = null;
        for (Bucket bucket : this.buckets) {
            boolean isConditionMet = bucket.exprs.isSatisfied(b, this.getExecContext());
            if (!isConditionMet) continue;
            result = bucket;
            break;
        }
        return result;
    }

    protected boolean hasNextBinding() {
        boolean result;
        if (this.slot != null) {
            return true;
        }
        if (this.iterator != null) {
            return this.iterator.hasNext();
        }
        this.slot = null;
        while (this.getInput().hasNext()) {
            Binding b2 = this.getInputNext();
            Bucket bucket = this.getBucket(b2);
            if (bucket != null) {
                if (bucket.isSpilling()) {
                    bucket.add(b2);
                    continue;
                }
                if (bucket.containsSeen(b2)) continue;
                if ((long)bucket.seen.size() < this.memThreshold) {
                    bucket.add(b2);
                    this.slot = b2;
                    break;
                }
                if (bucket.isSpilling()) continue;
                bucket.startSpilling();
                bucket.add(b2);
                continue;
            }
            this.slot = b2;
            break;
        }
        if (this.slot != null) {
            result = true;
        } else {
            this.iterator = Iter.iter(this.buckets).flatMap(b -> b.db == null ? Iter.empty() : Iter.onClose((Iterator)b.db.iterator(), () -> b.close()));
            result = this.iterator.hasNext();
        }
        return result;
    }

    private Binding getInputNext() {
        Binding b = (Binding)this.getInput().next();
        b = new BindingProjectNamed(b);
        return b;
    }

    protected Binding moveToNextBinding() {
        if (this.slot != null) {
            Binding b = this.slot;
            this.slot = null;
            return b;
        }
        if (this.iterator != null) {
            Binding b = this.iterator.next();
            return b;
        }
        throw new InternalErrorException();
    }

    protected void closeSubIterator() {
        if (this.iterator != null) {
            this.iterator = null;
            Iter.close(this.iterator);
        }
        this.buckets = null;
    }

    protected void requestSubCancel() {
    }

    protected class Bucket {
        protected ExprList exprs;
        protected DistinctDataBag<Binding> db = null;
        protected Set<Binding> seen = new LinkedHashSet<Binding>();

        public Bucket(ExprList exprs) {
            this.exprs = exprs;
        }

        public boolean isSpilling() {
            return this.db != null;
        }

        public void startSpilling() {
            Preconditions.checkState((!this.isSpilling() ? 1 : 0) != 0, (Object)"Bucket already in spilling mode");
            ThresholdPolicy policy = ThresholdPolicyFactory.policyFromContext((Context)QueryIterDistinctConditional.this.getExecContext().getContext());
            BindingComparator comparator = new BindingComparator(QueryIterDistinctConditional.this.preserveOrder, QueryIterDistinctConditional.this.getExecContext());
            this.db = BagFactory.newDistinctBag((ThresholdPolicy)policy, (SerializationFactory)SerializationFactoryFinder.bindingSerializationFactory(), (Comparator)comparator);
        }

        public void add(Binding b) {
            if (this.isSpilling()) {
                this.db.add((Object)b);
            } else {
                this.seen.add(b);
            }
        }

        public boolean containsSeen(Binding b) {
            return this.seen.contains(b);
        }

        public void close() {
            if (this.db != null) {
                this.db.close();
            }
            this.db = null;
            this.seen = null;
        }
    }
}

