/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.benchmark;

import com.google.common.collect.Iterators;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Stream;
import org.aksw.jena_sparql_api.sparql.ext.benchmark.FN_BenchmarkOld;
import org.aksw.jena_sparql_api.sparql.ext.json.JenaJsonUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.pfunction.PFuncSimpleAndList;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropertyFunction;
import org.apache.jena.sparql.pfunction.PropertyFunctionFactory;
import org.apache.jena.sparql.util.IterLib;

public class PropertyFunctionFactoryBenchmark
implements PropertyFunctionFactory {
    protected Function<? super Path, ? extends Stream<? extends Path>> fn;

    public PropertyFunction create(String uri) {
        return new PropertyFunctionBenchmark();
    }

    public static class PropertyFunctionBenchmark
    extends PFuncSimpleAndList {
        public QueryIterator execEvaluated(Binding binding, Node subject, Node predicate, PropFuncArg object, ExecutionContext execCxt) {
            QueryIterator result;
            boolean includeResultSet;
            RDFConnection conn = FN_BenchmarkOld.getConnection(execCxt);
            JsonObject json = FN_BenchmarkOld.benchmark(conn, subject, includeResultSet = object.getArgListSize() >= 3);
            if (json == null) {
                result = IterLib.noResults((ExecutionContext)execCxt);
            } else {
                Node timeNode = object.getArg(0);
                Node sizeNode = object.getArg(1);
                Node resultSetNode = includeResultSet ? object.getArg(2) : null;
                BindingBuilder b = BindingFactory.builder((Binding)binding);
                b.add((Var)timeNode, NodeValue.makeDecimal((BigDecimal)json.get("time").getAsBigDecimal()).asNode());
                b.add((Var)sizeNode, NodeValue.makeInteger((BigInteger)json.get("size").getAsBigInteger()).asNode());
                if (resultSetNode != null) {
                    b.add((Var)resultSetNode, JenaJsonUtils.convertJsonOrValueToNodeValue(json.get("result")).asNode());
                }
                result = QueryIterPlainWrapper.create((Iterator)Iterators.singletonIterator((Object)b.build()), (ExecutionContext)execCxt);
            }
            return result;
        }
    }
}

