/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.sys;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.aksw.jenax.arq.datatype.lambda.Lambda;
import org.aksw.jenax.arq.datatype.lambda.NodeValueLambda;
import org.aksw.jenax.arq.util.binding.BindingUtils;
import org.aksw.jenax.arq.util.expr.ExprUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.Rename;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase;
import org.apache.jena.sparql.function.FunctionEnv;

public class FN_LambdaOf
extends FunctionBase {
    public static void main(String[] args) {
        String str = String.join((CharSequence)"\n", "PREFIX eg: <http://www.example.org/>", "PREFIX norse: <https://w3id.org/aksw/norse#>", "PREFIX sys: <http://jsa.aksw.org/fn/sys/>", "SELECT ?fn {", "  BIND(norse:sparql.fn.of(?x, IRI(CONCAT(STR(eg:), STR(sys:nextLong())))) AS ?fn)", "  LATERAL {", "      { BIND(norse:map.computeIfAbsent('myMap', 'key1', ?fn) AS ?v) }", "    UNION", "      { BIND(norse:map.computeIfAbsent('myMap', 'key1', ?fn) AS ?v) }", "    UNION", "      { BIND(norse:map.computeIfAbsent('myMap', 'key2', ?fn) AS ?v) }", "  }", "}");
        str = String.join((CharSequence)"\n", "PREFIX norse: <https://w3id.org/aksw/norse#>", "SELECT ?helloFn ?msg {", "  BIND('Hi' AS ?salutation)", "  BIND(norse:sparql.fn.of(?x, CONCAT(?salutation, ' ', ?x)) AS ?helloFn)", "  BIND(norse:sparql.fn.call(?helloFn, 'Lorenz') AS ?msg)", "}");
        System.out.println(str);
        Query query = QueryFactory.create((String)str);
        try (QueryExec qe = QueryExec.newBuilder().dataset(DatasetGraphFactory.create()).query(query).build();){
            System.out.println(ResultSetFormatter.asText((ResultSet)ResultSet.adapt((RowSet)qe.select())));
        }
    }

    public NodeValue exec(Binding binding, ExprList args, String uri, FunctionEnv env) {
        int n = args.size();
        if (n == 0) {
            throw new RuntimeException("At least 1 argument required which is an expression");
        }
        List scopedExprs = args.getList();
        List scopedArgList = scopedExprs.subList(0, n - 1);
        ArrayList<Var> scopedArgVars = new ArrayList<Var>(scopedArgList.size());
        int argIdx = 1;
        for (Expr arg : scopedArgList) {
            Var v2 = arg.asVar();
            if (v2 == null) {
                throw new RuntimeException("Argument #" + argIdx + " is not a variable");
            }
            scopedArgVars.add(v2);
            ++argIdx;
        }
        HashSet scopedArgVarsSet = new HashSet(scopedArgVars);
        Expr scopedRawExpr = (Expr)scopedExprs.get(n - 1);
        Binding effBinding = BindingUtils.project((Binding)binding, (Iterator)binding.vars(), scopedArgVarsSet);
        Expr scopedExpr = Substitute.substitute((Expr)scopedRawExpr, (Binding)effBinding);
        List<Var> unscopedArgVars = scopedArgVars.stream().map(v -> (Var)Rename.reverseVarRename((Node)v)).toList();
        Expr unscopedExpr = ExprUtils.reverseVarRename((Expr)scopedExpr);
        Lambda lambda = new Lambda(unscopedArgVars, unscopedExpr);
        NodeValueLambda result = new NodeValueLambda(lambda);
        return result;
    }

    public NodeValue exec(List<NodeValue> args) {
        throw new RuntimeException("Should not be called");
    }

    public void checkBuild(String uri, ExprList args) {
    }
}

