/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.geosparql;

import org.aksw.jena_sparql_api.sparql.ext.geosparql.F_ParsePolyline;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.F_ST_VoronoiPolygons;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.F_Wkb2Wkt;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.GeoSparqlExAggregators;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.GeoSparqlExFunctions;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.H3ToGeometryAgg;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.JenaExtensionsH3;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.RDFDatatypeGeoJSON;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.RDFDatatypeWkbLiteral;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.STDumpPF;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.WithinBoxMultipolygonPF;
import org.aksw.jenax.arq.functionbinder.FunctionBinder;
import org.aksw.jenax.arq.functionbinder.FunctionBinders;
import org.aksw.jenax.arq.functionbinder.FunctionGenerator;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.datatype.WKTDatatype;
import org.apache.jena.geosparql.spatial.filter_functions.DistanceFF;
import org.apache.jena.sparql.expr.aggregate.AccumulatorFactory;
import org.apache.jena.sparql.expr.aggregate.AggregateRegistry;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.apache.jena.sparql.pfunction.PropertyFunctionRegistry;
import org.locationtech.jts.geom.Geometry;

public class JenaExtensionsGeoSparqlX {
    public static void register() {
        JenaExtensionsGeoSparqlX.loadDefs(FunctionRegistry.get());
        AggregateRegistry.register((String)"http://www.opengis.net/def/function/geosparql/collect", (AccumulatorFactory)GeoSparqlExAggregators.wrap1(GeoSparqlExAggregators::aggGeometryWrapperCollection));
        AggregateRegistry.register((String)"https://w3id.org/aksw/norse#geo.aggCollect", (AccumulatorFactory)GeoSparqlExAggregators.wrap1(GeoSparqlExAggregators::aggGeometryWrapperCollection));
        AggregateRegistry.register((String)"http://www.opengis.net/def/function/geosparql/aggUnion", (AccumulatorFactory)GeoSparqlExAggregators.wrap1(GeoSparqlExAggregators::aggUnionGeometryWrapperCollection));
        AggregateRegistry.register((String)"http://www.opengis.net/def/function/geosparql/aggIntersection", (AccumulatorFactory)GeoSparqlExAggregators.wrap1(GeoSparqlExAggregators::aggIntersectionGeometryWrapperCollection));
        AggregateRegistry.register((String)"http://www.opengis.net/def/function/geosparql/h3ToGeom", (AccumulatorFactory)H3ToGeometryAgg.h3CellIdAccumulatorFactory);
    }

    public static void loadDefs(FunctionRegistry registry) {
        TypeMapper.getInstance().registerDatatype(RDFDatatypeWkbLiteral.get());
        TypeMapper.getInstance().registerDatatype(RDFDatatypeGeoJSON.get());
        registry.put("http://www.opengis.net/def/function/geosparql/wkb2wkt", F_Wkb2Wkt.class);
        registry.put("http://www.opengis.net/def/function/geosparql/parsePolyline", F_ParsePolyline.class);
        WKTDatatype.registerDatatypes();
        FunctionBinder binder = FunctionBinders.getDefaultFunctionBinder();
        FunctionGenerator generator = binder.getFunctionGenerator();
        generator.getConverterRegistry().register(Geometry.class, GeometryWrapper.class, geometry -> new GeometryWrapper(geometry, "http://www.opengis.net/ont/geosparql#wktLiteral"), GeometryWrapper::getParsingGeometry);
        binder.getFunctionGenerator().getJavaToRdfTypeMap().put(Geometry.class, GeometryWrapper.class);
        generator.getTypeByClassOverrides().put(GeometryWrapper.class, "http://www.opengis.net/ont/geosparql#wktLiteral");
        binder.registerAll(GeoSparqlExFunctions.class);
        PropertyFunctionRegistry ppfRegistry = PropertyFunctionRegistry.get();
        ppfRegistry.put("http://jena.apache.org/spatial#withinBoxMultipolygonGeom", WithinBoxMultipolygonPF.class);
        ppfRegistry.put("http://jena.apache.org/spatial#st_dump", STDumpPF.class);
        registry.put("http://jena.apache.org/function/spatial#st_voronoi_polygons", F_ST_VoronoiPolygons.class);
        registry.put("http://www.opengis.net/def/function/geosparql/distance", DistanceFF.class);
        JenaExtensionsH3.init(binder, ppfRegistry);
    }
}

