/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.benchmark;

import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.aksw.jena_sparql_api.sparql.ext.json.JenaJsonUtils;
import org.aksw.jenax.arq.util.binding.ResultSetUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class E_CompareResultSet
extends FunctionBase2 {
    private static final Logger logger = LoggerFactory.getLogger(E_CompareResultSet.class);

    public NodeValue exec(NodeValue v1, NodeValue v2) {
        int relevantAndRetrievedSize;
        int retrievedSize;
        int relevantSize;
        JsonElement j2;
        Node n1 = v1.asNode();
        Node n2 = v2.asNode();
        Object o1 = n1.getLiteralValue();
        Object o2 = n2.getLiteralValue();
        JsonElement j1 = o1 instanceof JsonElement ? (JsonElement)o1 : null;
        JsonElement jsonElement = j2 = o2 instanceof JsonElement ? (JsonElement)o2 : null;
        if (j1 != null && j2 != null) {
            String s1 = j1.toString();
            String s2 = j2.toString();
            ResultSet r1 = ResultSetFactory.fromJSON((InputStream)new ByteArrayInputStream(s1.getBytes()));
            ResultSet r2 = ResultSetFactory.fromJSON((InputStream)new ByteArrayInputStream(s2.getBytes()));
            Multiset m1 = ResultSetUtils.toMultiset((ResultSet)r1);
            Multiset m2 = ResultSetUtils.toMultiset((ResultSet)r2);
            Multiset both = Multisets.intersection((Multiset)m1, (Multiset)m2);
            relevantSize = m1.size();
            retrievedSize = m2.size();
            relevantAndRetrievedSize = both.size();
        } else {
            throw new ExprEvalException("At least one of the arguments could not be parsed as a SPARQL result set");
        }
        double precision = retrievedSize == 0 ? (relevantSize == 0 ? 1.0 : 0.0) : (double)relevantAndRetrievedSize / (double)retrievedSize;
        double recall = relevantSize == 0 ? 1.0 : (double)relevantAndRetrievedSize / (double)relevantSize;
        double denominator = precision + recall;
        double fmeasure = denominator == 0.0 ? 0.0 : 2.0 * (precision * recall) / denominator;
        JsonObject json = new JsonObject();
        json.addProperty("precision", (Number)precision);
        json.addProperty("recall", (Number)recall);
        json.addProperty("fmeasure", (Number)fmeasure);
        json.addProperty("expectedSize", (Number)relevantSize);
        json.addProperty("actualSize", (Number)retrievedSize);
        NodeValue result = JenaJsonUtils.convertJsonOrValueToNodeValue(json);
        return result;
    }
}

