/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.xml;

import java.util.Iterator;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.aksw.jena_sparql_api.sparql.ext.xml.JenaXmlUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class E_XPath
extends FunctionBase2 {
    private static final Logger logger = LoggerFactory.getLogger(E_XPath.class);
    protected XPathFactory xPathFactory;

    public E_XPath() {
        this(XPathFactory.newInstance());
    }

    public E_XPath(XPathFactory xPathFactory) {
        this.xPathFactory = xPathFactory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NodeValue exec(NodeValue nv, NodeValue query) {
        Iterator<Node> nodes;
        org.w3c.dom.Node xmlNode = JenaXmlUtils.extractXmlNode(nv);
        if (xmlNode == null) throw new ExprEvalException("XPath xml node argument is not an xml node ");
        if (!query.isString()) throw new ExprEvalException("XPath query argument is not a string: " + String.valueOf(query));
        String queryStr = query.getString();
        try {
            nodes = JenaXmlUtils.evalXPath(this.xPathFactory, queryStr, xmlNode);
        }
        catch (XPathExpressionException e) {
            logger.warn("XPath evaluation failed", (Throwable)e);
            throw new ExprEvalException("XPath evaluation failed");
        }
        if (!nodes.hasNext()) throw new ExprEvalException("XPath " + queryStr + " did not match any results");
        Node node = nodes.next();
        if (nodes.hasNext()) {
            throw new ExprEvalException("XPath " + queryStr + " evaluated to multiple results");
        }
        NodeValue result = NodeValue.makeNode((Node)node);
        if (result != null) return result;
        throw new ExprEvalException("xpath evaluation yeld null result");
    }
}

