/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.json;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.LazilyParsedNumber;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.GsonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.IntStream;
import org.aksw.jena_sparql_api.rdf.collections.NodeMapperFromRdfDatatype;
import org.aksw.jena_sparql_api.sparql.ext.json.NodeValueJson;
import org.aksw.jena_sparql_api.sparql.ext.json.RDFDatatypeJson;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterNullIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprException;
import org.apache.jena.sparql.expr.ExprTypeException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.scripting.NV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenaJsonUtils {
    private static final Logger logger = LoggerFactory.getLogger(JenaJsonUtils.class);
    private static final ThreadLocal<Cache<String, JsonPath>> compiledPathCache = ThreadLocal.withInitial(() -> CacheBuilder.newBuilder().maximumSize(1000L).build());
    private static final ThreadLocal<ParseContext> parseContext = ThreadLocal.withInitial(() -> JsonPath.using((Configuration)Configuration.builder().jsonProvider((JsonProvider)new GsonJsonProvider()).build()));

    public static JsonObject extractJsonObjectOrNull(Node node) {
        JsonElement tmp = JenaJsonUtils.extractOrNull(node);
        JsonObject result = tmp == null || !tmp.isJsonObject() ? null : tmp.getAsJsonObject();
        return result;
    }

    public static JsonElement extractOrNull(Node node) {
        Object value;
        JsonElement result = null;
        if (node.isLiteral() && (value = node.getLiteralValue()) instanceof JsonElement) {
            result = (JsonElement)value;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JsonElement extractChecked(Node node) {
        if (node == null) {
            return null;
        }
        if (!node.isLiteral()) throw new IllegalArgumentException("Provided argument node is not a literal");
        Object obj = node.getLiteralValue();
        if (!(obj instanceof JsonElement)) throw new IllegalArgumentException("The provided argument node does not hold a json element: " + String.valueOf(node));
        return (JsonElement)obj;
    }

    public static JsonElement extractChecked(NodeValue nv) {
        JsonElement result;
        if (nv instanceof NodeValueJson) {
            result = ((NodeValueJson)nv).getJsonElement();
        } else {
            Node node = nv.getNode();
            result = JenaJsonUtils.extractChecked(node);
        }
        return result;
    }

    public static JsonElement requireJsonElement(NodeValue nv) {
        JsonElement elt = JenaJsonUtils.extractJsonElementOrNull(nv);
        if (elt == null) {
            NodeValue.raise((ExprException)new ExprTypeException("Not a JSON element"));
        }
        return elt;
    }

    public static JsonElement extractJsonElementOrNull(NodeValue nv) {
        JsonElement result = null;
        if (nv instanceof NodeValueJson) {
            result = ((NodeValueJson)nv).getJsonElement();
        } else {
            Node node = nv.getNode();
            if (node != null) {
                result = JenaJsonUtils.extractOrNull(node);
            }
        }
        return result;
    }

    public static boolean isJsonElement(NodeValue nv) {
        boolean result = false;
        if (nv instanceof NodeValueJson) {
            result = true;
        } else if (nv != null) {
            Node asNode = nv.asNode();
            result = asNode.getLiteralDatatype() instanceof RDFDatatypeJson;
        }
        return result;
    }

    public static NodeValue makeJsonNodeValue(Node node) {
        JsonElement jsonElement = JenaJsonUtils.extractOrNull(node);
        if (jsonElement == null) {
            throw new RuntimeException("Not a json node: " + String.valueOf(node));
        }
        return new NodeValueJson(jsonElement);
    }

    public static JsonElement enforceJsonElement(NodeValue nv) {
        JsonElement result = JenaJsonUtils.extractJsonElementOrNull(nv);
        if (result == null) {
            Node node = nv.asNode();
            result = JenaJsonUtils.nodeToJsonElement(node);
        }
        return result;
    }

    public static JsonElement nodeToJsonElement(Node node) {
        JsonNull result;
        if (node == null) {
            result = JsonNull.INSTANCE;
        } else if (node.isLiteral()) {
            result = JenaJsonUtils.nodeLiteralToJsonElement(node);
        } else if (node.isURI()) {
            result = new JsonPrimitive(node.getURI());
        } else if (node.isBlank()) {
            result = new JsonPrimitive(node.getBlankNodeLabel());
        } else {
            throw new IllegalArgumentException("Unknown term type - Neither literal, iri nor blank node: " + String.valueOf(node));
        }
        return result;
    }

    public static JsonElement nodeLiteralToJsonElement(Node node) {
        JsonPrimitive result;
        if (!node.isLiteral()) {
            throw new IllegalArgumentException("Not a literal");
        }
        Object obj = node.getLiteralValue();
        if (obj instanceof String) {
            String value = (String)obj;
            result = new JsonPrimitive(value);
        } else if (obj instanceof Number) {
            Number value = (Number)obj;
            result = new JsonPrimitive(value);
        } else if (obj instanceof Boolean) {
            Boolean value = (Boolean)obj;
            result = new JsonPrimitive(value);
        } else {
            String value = node.getLiteralLexicalForm();
            result = new JsonPrimitive(value);
        }
        return result;
    }

    public static NodeValue convertJsonOrValueToNodeValue(Object o) {
        RDFDatatypeJson dtype = RDFDatatypeJson.get();
        Gson gson = dtype.getGson();
        NodeValue result = JenaJsonUtils.convertJsonOrValueToNodeValue(o, gson);
        return result;
    }

    public static NodeValue convertJsonOrValueToNodeValue(Object o, Gson gson) {
        NodeValue result;
        boolean isPrimitive = JenaJsonUtils.isJavaJsonPrimitive(o);
        if (o == null) {
            result = null;
        } else if (isPrimitive) {
            result = NV.toNodeValue((Object)o);
        } else if (o instanceof JsonElement) {
            JsonElement e = (JsonElement)o;
            result = JenaJsonUtils.convertJsonToNodeValue(e);
        } else {
            String str = gson.toJson(o);
            JsonElement e = (JsonElement)gson.fromJson(str, JsonElement.class);
            result = JenaJsonUtils.convertJsonToNodeValue(e);
        }
        return result;
    }

    public static boolean isJavaJsonPrimitive(Object o) {
        boolean result = o instanceof Boolean || o instanceof Number || o instanceof String;
        return result;
    }

    public static String convertJsonOrValueToString(Object o, Gson gson) {
        String result;
        boolean isPrimitive = JenaJsonUtils.isJavaJsonPrimitive(o);
        if (o == null) {
            result = null;
        } else if (isPrimitive) {
            result = Objects.toString(o);
        } else if (o instanceof JsonElement) {
            JsonElement e = (JsonElement)o;
            result = e.toString();
        } else {
            result = gson.toJson(o);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NodeValue convertJsonToNodeValue(JsonElement e) {
        if (e == null) {
            return null;
        }
        if (e.isJsonPrimitive()) {
            JsonPrimitive p = e.getAsJsonPrimitive();
            if (p.isString()) {
                return NodeValue.makeString((String)p.getAsString());
            }
            if (p.isNumber()) {
                Number pAsNumber = p.getAsNumber();
                if (!(pAsNumber instanceof LazilyParsedNumber)) return NV.toNodeValue((Object)pAsNumber);
                pAsNumber = JenaJsonUtils.findNearestNumber(p);
                return NV.toNodeValue((Object)pAsNumber);
            }
            if (!p.isBoolean()) throw new RuntimeException("Unexpected json primitive: " + String.valueOf(e));
            return NodeValue.makeBoolean((boolean)p.getAsBoolean());
        }
        if (e.isJsonObject()) return new NodeValueJson(e);
        if (e.isJsonArray()) {
            return new NodeValueJson(e);
        }
        if (!e.isJsonNull()) throw new RuntimeException("Datatype not supported " + String.valueOf(e));
        return null;
    }

    public static Number findNearestNumber(JsonPrimitive p) {
        String pAsString = p.getAsNumber().toString();
        try {
            return Long.parseLong(pAsString);
        }
        catch (NumberFormatException e1) {
            try {
                return Double.valueOf(pAsString);
            }
            catch (NumberFormatException e2) {
                return p.getAsBigDecimal();
            }
        }
    }

    public static NodeValue evalJsonPath(Gson gson, NodeValue nv, NodeValue query) {
        JsonElement json = JenaJsonUtils.extractJsonElementOrNull(nv);
        NodeValue result = null;
        if (query.isString() && json != null) {
            String queryStr = query.getString();
            Object o = null;
            try {
                JsonPath compiledPath = (JsonPath)compiledPathCache.get().get((Object)queryStr, () -> JsonPath.compile((String)queryStr, (Predicate[])new Predicate[0]));
                o = parseContext.get().parse((Object)json).read(compiledPath);
            }
            catch (Exception e) {
                if (NodeValue.VerboseWarnings) {
                    logger.warn(e.getLocalizedMessage());
                }
                NodeValue.raise((ExprException)new ExprTypeException("Error evaluating json path", (Throwable)e));
            }
            if (o == null) {
                NodeValue.raise((ExprException)new ExprTypeException("JsonPath evaluated to null"));
            } else {
                result = JenaJsonUtils.convertJsonOrValueToNodeValue(o, gson);
                if (result == null) {
                    NodeValue.raise((ExprException)new ExprTypeException("Json evaluated to null (probably JsonNull)"));
                }
            }
        } else {
            NodeValue.raise((ExprException)new ExprTypeException("Invalid arguments to json path"));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QueryIterator unnestJsonArray(Gson gson, Binding binding, Node index, ExecutionContext execCxt, Node node, Var outputVar) {
        JsonElement data;
        boolean isJson;
        Var indexVarTmp = null;
        Integer indexVal = null;
        if (index != null) {
            if (index.isVariable()) {
                indexVarTmp = (Var)index;
            } else {
                if (!index.isLiteral()) throw new ExprEvalException("Index into json array is not a number " + String.valueOf(index));
                Object obj = NodeMapperFromRdfDatatype.toJavaCore((Node)index, (RDFDatatype)index.getLiteralDatatype());
                if (!(obj instanceof Number)) throw new ExprEvalException("Index into json array is a literal but not a number: " + String.valueOf(index));
                indexVal = ((Number)obj).intValue();
            }
        }
        Var indexVar = indexVarTmp;
        QueryIterator result = null;
        boolean bl = isJson = node != null && node.isLiteral() && node.getLiteralDatatype() instanceof RDFDatatypeJson;
        if (isJson && (data = (JsonElement)node.getLiteralValue()) != null && data.isJsonArray()) {
            void var13_16;
            JsonArray arr = data.getAsJsonArray();
            if (indexVal != null) {
                Binding b = JenaJsonUtils.itemToBinding(binding, arr, indexVal, gson, indexVar, outputVar);
                Iterator<Binding> iterator = Collections.singleton(b).iterator();
            } else {
                Iterator iterator = IntStream.range(0, arr.size()).mapToObj(i -> {
                    Binding r = JenaJsonUtils.itemToBinding(binding, arr, i, gson, indexVar, outputVar);
                    return r;
                }).iterator();
            }
            result = QueryIterPlainWrapper.create((Iterator)var13_16, (ExecutionContext)execCxt);
        }
        if (result != null) return result;
        return QueryIterNullIterator.create((ExecutionContext)execCxt);
    }

    public static Binding itemToBinding(Binding binding, JsonArray arr, int i, Gson gson, Var indexVar, Var outputVar) {
        Node n;
        JsonElement item;
        try {
            item = arr.get(i);
        }
        catch (Exception e) {
            throw new ExprEvalException((Throwable)e);
        }
        RDFDatatypeJson jsonDatatype = RDFDatatypeJson.get();
        NodeValue nv = JenaJsonUtils.convertJsonToNodeValue(item);
        Node node = n = nv == null ? null : nv.asNode();
        if (n != null) {
            binding = BindingFactory.binding((Binding)binding, (Var)outputVar, (Node)n);
        }
        if (indexVar != null) {
            binding = BindingFactory.binding((Binding)binding, (Var)indexVar, (Node)NodeValue.makeInteger((long)i).asNode());
        }
        return binding;
    }

    public static NodeValue fromString(String jsonStr) {
        Node node = NodeFactory.createLiteral((String)jsonStr, (RDFDatatype)RDFDatatypeJson.get());
        NodeValue result = NodeValue.makeNode((Node)node);
        return result;
    }

    public static Node createLiteralByValue(JsonElement json) {
        RDFDatatypeJson dtype = RDFDatatypeJson.get();
        Node result = NodeFactory.createLiteralByValue((Object)json, (RDFDatatype)dtype);
        return result;
    }

    public static NodeValue makeNodeValue(JsonElement json) {
        NodeValueJson result = new NodeValueJson(json);
        return result;
    }
}

