/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.json;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import org.aksw.jena_sparql_api.sparql.ext.json.JenaJsonUtils;
import org.apache.jena.sparql.expr.ExprException;
import org.apache.jena.sparql.expr.ExprTypeException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase1;

public class E_JsonEntries
extends FunctionBase1 {
    protected Gson gson;

    public E_JsonEntries() {
        this(new Gson());
    }

    public E_JsonEntries(Gson gson) {
        this.gson = gson;
    }

    public static JsonArray keysToArray(JsonObject jo, String keyAttrName, String valueAttrName) {
        JsonArray result = new JsonArray();
        for (Map.Entry e : jo.entrySet()) {
            JsonObject item = new JsonObject();
            item.addProperty(keyAttrName, (String)e.getKey());
            item.add(valueAttrName, (JsonElement)e.getValue());
            result.add((JsonElement)item);
        }
        return result;
    }

    public NodeValue exec(NodeValue nv) {
        NodeValue result = null;
        JsonElement json = JenaJsonUtils.extractJsonElementOrNull(nv);
        if (json != null && json.isJsonObject() && !json.isJsonArray()) {
            JsonObject jo = json.getAsJsonObject();
            JsonArray arr = E_JsonEntries.keysToArray(jo, "key", "value");
            result = JenaJsonUtils.convertJsonToNodeValue((JsonElement)arr);
        }
        if (result == null) {
            NodeValue.raise((ExprException)new ExprTypeException("Argument was not a json object"));
        }
        return result;
    }
}

