/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.geosparql;

import org.aksw.jena_sparql_api.sparql.ext.geosparql.GeoConstraintFactory;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.GeoExprUtils;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.WGS84;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.sparql.fragment.api.Fragment3;
import org.aksw.jenax.sparql.fragment.impl.Fragment3Impl;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.vocabulary.XSD;
import org.locationtech.jts.geom.Envelope;

public class GeoConstraintFactoryWgs
implements GeoConstraintFactory {
    protected Fragment3 fragment;
    protected Node castNode;

    protected GeoConstraintFactoryWgs(Fragment3 fragment, Node castNode) {
        this.fragment = fragment;
        this.castNode = castNode;
    }

    public static GeoConstraintFactoryWgs of(String xPropertyIri, String yPropertyIri, String castIri) {
        Node xProperty = NodeFactory.createURI((String)xPropertyIri);
        Node yProperty = NodeFactory.createURI((String)yPropertyIri);
        Node castNode = castIri == null ? null : NodeFactory.createURI((String)castIri);
        return GeoConstraintFactoryWgs.of(xProperty, yProperty, castNode);
    }

    public static GeoConstraintFactoryWgs of(Node xProperty, Node yProperty, Node castNode) {
        Fragment3 fragment = GeoConstraintFactoryWgs.createXyFragment(xProperty, yProperty);
        return new GeoConstraintFactoryWgs(fragment, castNode);
    }

    public static GeoConstraintFactoryWgs create() {
        return GeoConstraintFactoryWgs.of(WGS84.xlong.asNode(), WGS84.lat.asNode(), XSD.xfloat.asNode());
    }

    public Fragment3 getFragment() {
        return this.fragment;
    }

    @Override
    public Var getIdVar() {
        return this.fragment.getS();
    }

    public Var getXVar() {
        return this.fragment.getP();
    }

    public Var getYVar() {
        return this.fragment.getO();
    }

    public Node getCastNode() {
        return this.castNode;
    }

    @Override
    public Expr createExpr(Envelope bounds) {
        Var xVar = this.getXVar();
        Var yVar = this.getYVar();
        Expr result = GeoExprUtils.createExprWgs84Intersects(xVar, yVar, bounds, this.castNode);
        return result;
    }

    @Override
    public String toWktString(Binding binding) {
        Var xVar = this.getXVar();
        Var yVar = this.getYVar();
        Node x = binding.get(xVar);
        Node y = binding.get(yVar);
        float vx = NodeValue.makeNode((Node)x).getFloat();
        float vy = NodeValue.makeNode((Node)y).getFloat();
        return "POINT (" + vx + " " + vy + ")";
    }

    public static Fragment3 createXyFragment(Node xProperty, Node yProperty) {
        ElementTriplesBlock elt = ElementUtils.createElementTriple((Triple[])new Triple[]{Triple.create((Node)Vars.s, (Node)xProperty, (Node)Vars.x), Triple.create((Node)Vars.s, (Node)yProperty, (Node)Vars.y)});
        Fragment3Impl result = new Fragment3Impl((Element)elt, Vars.s, Vars.x, Vars.y);
        return result;
    }
}

