/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.geosparql;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.DBSCANClusterer;
import org.aksw.jena_sparql_api.sparql.ext.util.PropFuncArgUtils;
import org.aksw.jenax.arq.datatype.RDFDatatypeNodeList;
import org.aksw.jenax.arq.util.binding.BindingUtils;
import org.aksw.jenax.arq.util.node.NodeCollection;
import org.aksw.jenax.arq.util.node.NodeList;
import org.aksw.jenax.arq.util.node.NodeListImpl;
import org.aksw.jenax.arq.util.var.Vars;
import org.apache.commons.math3.ml.clustering.Cluster;
import org.apache.commons.math3.ml.clustering.Clusterable;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.UnitsConversionException;
import org.apache.jena.geosparql.implementation.vocabulary.Geo;
import org.apache.jena.geosparql.spatial.SpatialIndex;
import org.apache.jena.geosparql.spatial.SpatialIndexException;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropertyFunctionBase;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbscanPf
extends PropertyFunctionBase {
    private static final Logger logger = LoggerFactory.getLogger(DbscanPf.class);
    public static final Query NEARBY_QUERY = QueryFactory.create((String)String.join((CharSequence)"\n", "PREFIX spatial: <http://jena.apache.org/spatial#>", "PREFIX uom: <http://www.opengis.net/def/uom/OGC/1.0/>", "SELECT ?s {", "  ?s spatial:nearbyGeom (?o ?radius uom:metre )", "}"));

    public QueryIterator exec(Binding binding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        List<Node> sList = PropFuncArgUtils.getAsList(argSubject);
        int sLength = sList.size();
        if (sLength < 4) {
            throw new QueryExecException("Expected at least 4 arguments");
        }
        if (sLength > 6) {
            throw new QueryExecException("Expected at most 6 arguments");
        }
        List<Node> oList = PropFuncArgUtils.getAsList(argObject);
        int oLength = oList.size();
        if (oLength > 2) {
            throw new QueryExecException("At most 2 output argument expected");
        }
        NodeList arr = (NodeList)BindingUtils.getValue((Binding)binding, (Node)sList.get(0)).getLiteralValue();
        int geoIdx = BindingUtils.getNumber((Binding)binding, (Node)sList.get(1)).intValue();
        double eps = BindingUtils.getNumber((Binding)binding, (Node)sList.get(2)).doubleValue();
        int minPts = BindingUtils.getNumber((Binding)binding, (Node)sList.get(3)).intValue();
        return null;
    }

    public static NodeList dbscan(NodeCollection arr, int geoIdx, final double eps, int minPts) {
        Graph indexGraph = GraphFactory.createDefaultGraph();
        Stopwatch sw = Stopwatch.createStarted();
        int i = 0;
        final ArrayList<CustomClusterable> clusterables = new ArrayList<CustomClusterable>(arr.size());
        final HashMap<Node, Integer> featureToIdx = new HashMap<Node, Integer>();
        for (Node tupleNode : arr) {
            Object tupleObj = tupleNode.getLiteralValue();
            NodeList tuple = (NodeList)tupleObj;
            Node geomLiteralNode = (Node)tuple.get(geoIdx);
            GeometryWrapper gw = GeometryWrapper.extract((Node)geomLiteralNode);
            CustomClusterable clusterable = new CustomClusterable(gw, tuple);
            clusterables.add(clusterable);
            Node featureNode = NodeFactory.createURI((String)("http://example.org/feature#_" + i));
            Node geomNode = NodeFactory.createURI((String)("http://example.org/geometry#_" + i));
            indexGraph.add(featureNode, Geo.HAS_GEOMETRY_NODE, geomNode);
            indexGraph.add(geomNode, Geo.AS_WKT_NODE, geomLiteralNode);
            featureToIdx.put(featureNode, i);
            ++i;
        }
        logger.info(String.format("Built ad-hoc in-memory model from %d items in %.3f seconds", clusterables.size(), (double)sw.elapsed(TimeUnit.MILLISECONDS) * 0.001));
        final Dataset index = DatasetFactory.wrap((DatasetGraph)DatasetGraphFactory.wrap((Graph)indexGraph));
        sw.reset().start();
        try {
            SpatialIndex.buildSpatialIndex((Dataset)index);
        }
        catch (SpatialIndexException e1) {
            throw new RuntimeException(e1);
        }
        logger.info(String.format("Built spatial index from %d items in %.3f seconds", clusterables.size(), (double)sw.elapsed(TimeUnit.MILLISECONDS) * 0.001));
        DBSCANClusterer<CustomClusterable> clusterer = new DBSCANClusterer<CustomClusterable>(eps, minPts){

            protected double distance(Clusterable xp1, Clusterable xp2) {
                double r;
                CustomClusterable p1 = (CustomClusterable)xp1;
                CustomClusterable p2 = (CustomClusterable)xp2;
                try {
                    r = p1.getGeometry().distanceGreatCircle(p2.getGeometry());
                }
                catch (UnitsConversionException | MismatchedDimensionException | TransformException | FactoryException e) {
                    throw new RuntimeException(e);
                }
                return r;
            }

            @Override
            protected List<CustomClusterable> getNeighbors(CustomClusterable point, Collection<CustomClusterable> points) {
                List<CustomClusterable> neighbours;
                try (QueryExec qe = QueryExec.dataset((DatasetGraph)index.asDatasetGraph()).query(NEARBY_QUERY).substitution("o", point.getGeometry().asNode()).substitution("radius", NodeFactoryExtra.doubleToNode((double)eps)).build();){
                    neighbours = qe.select().stream().map(b -> b.get(Vars.s)).map(f -> (CustomClusterable)clusterables.get((Integer)featureToIdx.get(f))).collect(Collectors.toList());
                }
                return neighbours;
            }
        };
        sw.reset().start();
        List clusters = clusterer.cluster(clusterables);
        logger.info(String.format("Clustering of %d items into %d results completed in %.3f seconds", clusterables.size(), clusters.size(), (double)sw.elapsed(TimeUnit.MILLISECONDS) * 0.001));
        NodeListImpl result = new NodeListImpl(new ArrayList(clusters.size()));
        for (Cluster cluster : clusters) {
            List members = cluster.getPoints();
            NodeListImpl memberList = new NodeListImpl(new ArrayList(members.size()));
            for (CustomClusterable member : members) {
                memberList.add((Object)NodeFactory.createLiteralByValue((Object)member.getValue(), (RDFDatatype)RDFDatatypeNodeList.get()));
            }
            Node item = NodeFactory.createLiteralByValue((Object)memberList, (RDFDatatype)RDFDatatypeNodeList.get());
            result.add((Object)item);
        }
        return result;
    }

    public static class CustomClusterable
    implements Clusterable {
        protected GeometryWrapper geom;
        protected NodeList value;

        public CustomClusterable(GeometryWrapper geom, NodeList value) {
            this.geom = geom;
            this.value = value;
        }

        public NodeList getValue() {
            return this.value;
        }

        public GeometryWrapper getGeometry() {
            return this.geom;
        }

        public double[] getPoint() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "CustomClusterable [value=" + String.valueOf(this.value) + "]";
        }
    }
}

