/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.geosparql;

import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.aksw.commons.collections.quadtree.LooseQuadTree;
import org.aksw.commons.collections.quadtree.QuadTreeNode;
import org.aksw.commons.rx.lookup.MapService;
import org.aksw.commons.util.range.CountInfo;
import org.aksw.commons.util.range.RangeUtils;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.GeoExprUtils;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.TileCluster;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.datatype.WKTDatatype;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.locationtech.jts.geom.Envelope;

public class DataServiceBBoxCache<C, T> {
    protected MapService<Envelope, T, T> listServiceBBox;
    protected LooseQuadTree<T> quadTree;
    protected Single<Boolean> checkedGlobalCount;
    protected long maxGlobalItemCount;
    protected long maxItemsPerTileCount;
    protected int acquireDepth;
    protected Map<Object, Single<QuadTreeNode<T>>> runningTasks = new ConcurrentHashMap<Object, Single<QuadTreeNode<T>>>();
    protected CompletableFuture<Boolean> checkedFetchAllAtOnce;

    public DataServiceBBoxCache(MapService<Envelope, T, T> listServiceBBox, long maxGlobalItemCount, long maxItemsPerTileCount, int acquireDepth) {
        this.listServiceBBox = listServiceBBox;
        Envelope maxBounds = new Envelope(-180.0, 180.0, -90.0, 90.0);
        this.quadTree = new LooseQuadTree(maxBounds, 18, 0.0f);
        this.maxItemsPerTileCount = maxItemsPerTileCount;
        this.maxGlobalItemCount = maxGlobalItemCount;
        this.acquireDepth = acquireDepth;
        this.resetGlobalCount();
    }

    protected synchronized void resetGlobalCount() {
        this.checkedGlobalCount = this.listServiceBBox.createPaginator(null).fetchCount(null, null).map(range -> {
            CountInfo countInfo = RangeUtils.toCountInfo((Range)range);
            boolean canUseGlobal = countInfo.getCount() < this.maxGlobalItemCount;
            return canUseGlobal;
        }).doOnError(t -> this.resetGlobalCount()).doOnSuccess(range -> {});
    }

    public Flowable<Resource> fetchData(Envelope bounds) {
        Flowable result = this.runWorkflow(bounds).flatMapIterable(node -> {
            ArrayList<TileCluster> r = new ArrayList<TileCluster>();
            if (!node.isLoaded()) {
                String wktStr = GeoExprUtils.boundsToWkt(node.getBounds());
                GeometryWrapper geom = WKTDatatype.INSTANCE.read(wktStr);
                TileCluster cluster = ((TileCluster)ModelFactory.createDefaultModel().createResource().as(TileCluster.class)).setKey(wktStr).setZoomClusterBounds(geom);
                r.add(cluster);
            }
            return r;
        });
        return result;
    }

    public Flowable<QuadTreeNode<T>> runWorkflow(Envelope bounds) {
        QuadTreeNode<T> rootNode = this.quadTree.getRootNode();
        Flowable result = this.checkedGlobalCount.flatMapPublisher(canUseGlobal -> {
            Flowable task = canUseGlobal != false ? this.runGlobalWorkflow(rootNode).toFlowable() : this.runTiledWorkflow(bounds);
            return task;
        });
        return result;
    }

    public Single<QuadTreeNode<T>> runGlobalWorkflow(QuadTreeNode<T> node) {
        Single result = this.listServiceBBox.createPaginator((Object)node.getBounds()).toMap().map(items -> {
            this.loadTaskAction(node, (Map<T, T>)items);
            return node;
        });
        return result;
    }

    public Flowable<QuadTreeNode<T>> runTiledWorkflow(Envelope bounds) {
        Collection<QuadTreeNode<T>> nodes = this.quadTree.acquireNodes(bounds, this.acquireDepth);
        for (QuadTreeNode<T> node2 : nodes) {
            if (!node2.isCountComplete() || node2.getInfMinItemCount() != 0L) continue;
            node2.setLoaded(true);
        }
        Flowable result = Flowable.fromIterable(nodes).flatMapSingle(node -> {
            Single<QuadTreeNode<T>> r = this.isCountingNeeded((QuadTreeNode<T>)node) ? this.createCountTask((QuadTreeNode<T>)node) : Single.just((Object)node);
            return r;
        }).flatMapSingle(node -> {
            boolean doLoad = this.isLoadingNeeded((QuadTreeNode<T>)node);
            return doLoad ? this.createLoadTask((QuadTreeNode<T>)node) : Single.just((Object)node);
        });
        return result;
    }

    public Single<QuadTreeNode<T>> createCountTask(QuadTreeNode<T> node) {
        Single countPromise = !this.isCountingNeeded(node) ? Single.just(node) : this.runningTasks.computeIfAbsent(node, n -> this.listServiceBBox.createPaginator((Object)node.getBounds()).fetchCount(Long.valueOf(this.maxItemsPerTileCount), null).map(RangeUtils::toCountInfo).map(itemCountInfo -> {
            long itemCount = itemCountInfo.getCount();
            node.setMinItemCount(itemCount);
            return node;
        }).doAfterTerminate(() -> this.runningTasks.remove(node)));
        return countPromise;
    }

    public boolean isCountingNeeded(QuadTreeNode<T> node) {
        return !this.isTooManyGeoms(node) && !node.isCountComplete();
    }

    boolean isLoadingNeeded(QuadTreeNode<T> node) {
        boolean noLoadingNeeded = node.isLoaded() || node.isCountComplete() && node.getInfMinItemCount() == 0L || this.isTooManyGeoms(node);
        return !noLoadingNeeded;
    }

    public boolean isTooManyGeoms(QuadTreeNode<T> node) {
        return node.getInfMinItemCount() >= this.maxItemsPerTileCount;
    }

    public void loadTaskAction(QuadTreeNode<T> node, Map<T, T> items) {
        for (Map.Entry<T, T> item : items.entrySet()) {
            node.addItem(item.getValue());
        }
        node.setLoaded(true);
    }

    Single<QuadTreeNode<T>> createLoadTask(QuadTreeNode<T> node) {
        return Single.just(node).map(n -> {
            Map map = this.listServiceBBox.createPaginator((Object)n.getBounds()).fetchMap();
            this.loadTaskAction((QuadTreeNode<T>)n, map);
            return n;
        });
    }

    public List<QuadTreeNode<T>> finalizeLoading(Collection<QuadTreeNode<T>> leafNodes) {
        TreeMap<Integer, Set> depthToNodes = new TreeMap<Integer, Set>();
        for (QuadTreeNode<T> node : leafNodes) {
            int depth = node.getDepth();
            depthToNodes.computeIfAbsent(depth, d -> Sets.newIdentityHashSet()).add(node);
        }
        int maxDepth = (Integer)depthToNodes.lastKey();
        Set mergedParents = Sets.newIdentityHashSet();
        for (int i = maxDepth; i >= 0; --i) {
            Set nodes = (Set)depthToNodes.get(i);
            Iterator iterator = nodes.iterator();
            while (iterator.hasNext()) {
                boolean didMerge;
                QuadTreeNode node = (QuadTreeNode)iterator.next();
                QuadTreeNode parent = node.getParent();
                if (parent == null || mergedParents.contains(parent) || !(didMerge = this.tryMergeNode(parent))) continue;
                mergedParents.add(parent);
                depthToNodes.computeIfAbsent(i - 1, d -> Sets.newIdentityHashSet()).add(parent);
            }
        }
        LinkedHashSet tmp = new LinkedHashSet(leafNodes.size());
        for (QuadTreeNode quadTreeNode : leafNodes) {
            QuadTreeNode q;
            QuadTreeNode parent;
            QuadTreeNode mergedAncestor = parent = quadTreeNode.getParent();
            while (mergedParents.contains(mergedAncestor) && (q = mergedAncestor.getParent()) != null) {
                mergedAncestor = q;
            }
            if (parent == null || parent == mergedAncestor) {
                tmp.add(quadTreeNode);
                continue;
            }
            tmp.add(mergedAncestor);
        }
        ArrayList<QuadTreeNode<T>> result = new ArrayList<QuadTreeNode<T>>(tmp);
        return result;
    }

    public boolean tryMergeNode(QuadTreeNode<T> node) {
        return false;
    }
}

