/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.fs;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.stream.Stream;
import org.aksw.jenax.arq.service.vfs.ServiceExecutorFactoryVfsUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.system.AsyncParser;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase1;

public class E_ProbeRdf
extends FunctionBase1 {
    protected int n = 100;

    public NodeValue exec(NodeValue nv) {
        NodeValue result;
        block10: {
            result = NodeValue.FALSE;
            try {
                Node node;
                String iri;
                Lang lang;
                if (!nv.isIRI() || (lang = RDFDataMgr.determineLang((String)(iri = (node = nv.asNode()).getURI()), null, null)) == null) break block10;
                Path path = ServiceExecutorFactoryVfsUtils.toPath((Node)node);
                try (Stream<Quad> stream = E_ProbeRdf.streamQuads(Files.newInputStream(path, new OpenOption[0]), null, iri);){
                    int i;
                    Iterator it = stream.iterator();
                    for (i = 0; i < this.n && it.hasNext(); ++i) {
                        it.next();
                    }
                    if (i > 0) {
                        result = NodeValue.TRUE;
                    }
                }
            }
            catch (Exception e) {
                result = NodeValue.FALSE;
            }
        }
        return result;
    }

    public static Stream<Quad> streamQuads(InputStream input, Lang lang, String baseIRI) {
        return AsyncParser.of((InputStream)input, (Lang)lang, (String)baseIRI).setChunkSize(10).streamQuads().map(q -> q.getGraph() != null ? q : Quad.create((Node)Quad.defaultGraphNodeGenerated, (Triple)q.asTriple()));
    }
}

