/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.picocli;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.aksw.jenax.arq.util.exec.query.ContextUtils;
import org.apache.jena.geosparql.InitGeoSPARQL;
import org.apache.jena.geosparql.configuration.GeoSPARQLConfig;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.mgt.Explain;
import org.apache.jena.sparql.util.Context;
import picocli.CommandLine;

public class CmdMixinArq
implements Serializable {
    private static final long serialVersionUID = 1L;
    @CommandLine.Option(names={"--explain"}, description={"Enable detailed ARQ log output"})
    public boolean explain = false;
    @CommandLine.Option(names={"--set"}, description={"Set ARQ options (key=value)"}, mapFallbackValue="true")
    public Map<String, String> arqOptions = new HashMap<String, String>();
    @CommandLine.Option(names={"--rdf10"}, description={"RDF 1.0 mode; e.g. xsd:string on literals matter (no longer supported by Jena5)"}, defaultValue="false")
    public boolean useRdf10 = false;
    @CommandLine.Option(names={"--geoindex"}, description={"Build Geoindex"})
    public boolean geoindex;

    public static void configureGlobal(CmdMixinArq cmd) {
        if (cmd.explain) {
            ARQ.setExecutionLogging((Explain.InfoLevel)Explain.InfoLevel.ALL);
        }
        if (cmd.geoindex) {
            System.setProperty("jena.geosparql.skip", String.valueOf(false));
            new InitGeoSPARQL().start();
            GeoSPARQLConfig.setupNoIndex();
        }
    }

    public static void configureCxt(Context cxt, CmdMixinArq cmd) {
        cxt.setIfUndef(ARQ.symJavaScriptLibFile, (Object)"functions.js");
        ContextUtils.putAll((Context)cxt, cmd.arqOptions);
    }
}

