/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql_path.api;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import org.aksw.jena_sparql_api.sparql_path.api.ConceptPathFinderFactory;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.sparql.path.SimplePath;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdfconnection.SparqlQueryConnection;
import org.apache.jena.sparql.path.P_Path0;

public abstract class ConceptPathFinderFactorySummaryBase<T extends ConceptPathFinderFactorySummaryBase<T>>
implements ConceptPathFinderFactory<T> {
    protected Model dataSummary;
    protected RDFDataSource dataSource;
    protected Boolean shortestPathsOnly;
    protected Boolean simplePathsOnly;
    protected Set<BiPredicate<? super SimplePath, ? super P_Path0>> pathValidators = new LinkedHashSet<BiPredicate<? super SimplePath, ? super P_Path0>>();

    @Override
    public T setDataSummary(Graph dataSummary) {
        this.dataSummary = ModelFactory.createModelForGraph((Graph)dataSummary);
        return this.self();
    }

    protected T self() {
        return (T)this;
    }

    @Override
    public T setDataSummary(Model dataSummary) {
        this.dataSummary = dataSummary;
        return this.self();
    }

    @Override
    public T setDataConnection(SparqlQueryConnection dataConnection) {
        throw new RuntimeException("This method should no longer be used.");
    }

    @Override
    public T setDataSource(RDFDataSource dataSource) {
        this.dataSource = dataSource;
        return this.self();
    }

    public T setDataConnection(RDFDataSource dataSource) {
        this.dataSource = dataSource;
        return this.self();
    }

    @Override
    public T setShortestPathsOnly(Boolean onOrOff) {
        this.shortestPathsOnly = onOrOff;
        return this.self();
    }

    @Override
    public T setSimplePathsOnly(Boolean onOrOff) {
        this.simplePathsOnly = onOrOff;
        return this.self();
    }

    @Override
    public T addPathValidator(BiPredicate<? super SimplePath, ? super P_Path0> pathValidator) {
        Objects.requireNonNull(pathValidator);
        this.pathValidators.add(pathValidator);
        return this.self();
    }

    @Override
    public Model getDataSummary() {
        return this.dataSummary;
    }

    @Override
    public SparqlQueryConnection getDataConnection() {
        throw new RuntimeException("This method should no longer be used");
    }

    public RDFDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public Boolean getShortestPathsOnly() {
        return this.shortestPathsOnly;
    }

    @Override
    public Boolean getSimplePathsOnly() {
        return this.simplePathsOnly;
    }
}

