/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api_sparql_path2.playground;

import java.util.Collection;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MapUtils {
    public static <K, V, W> Map<K, Map<V, W>> mergeNestedMap(Map<K, Map<V, W>> a, Map<K, Map<V, W>> b, BinaryOperator<W> mergeFn) {
        Map<K, Map<V, W>> result = MapUtils.mergeMaps(a, b, (x, y) -> MapUtils.mergeMaps(x, y, mergeFn));
        return result;
    }

    public static <K, V> Map<K, V> mergeMaps(Map<K, V> a, Map<K, V> b, BinaryOperator<V> mergeFn) {
        Map<Object, Object> result = Stream.of(a, b).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, mergeFn));
        return result;
    }

    public static <K, V> void mergeMapsInPlace(Map<K, V> tgt, Map<K, V> src, BinaryOperator<V> mergeFn) {
        src.forEach((k, v) -> {
            Object existing = tgt.get(k);
            Object newV = existing == null ? v : mergeFn.apply(existing, v);
            tgt.put(k, newV);
        });
    }
}

