/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql_path2;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.aksw.commons.jena.jgrapht.LabeledEdge;
import org.aksw.commons.jena.jgrapht.LabeledEdgeImpl;
import org.aksw.commons.rx.lookup.LookupService;
import org.aksw.commons.rx.lookup.LookupServiceFilterKey;
import org.aksw.commons.rx.lookup.MapService;
import org.aksw.commons.util.triplet.Triplet;
import org.aksw.commons.util.triplet.TripletImpl;
import org.aksw.jena_sparql_api.lookup.LookupServiceListService;
import org.aksw.jena_sparql_api.lookup.MapServiceUtils;
import org.aksw.jena_sparql_api.shape.ResourceShape;
import org.aksw.jena_sparql_api.shape.ResourceShapeBuilder;
import org.aksw.jena_sparql_api.sparql_path2.NestedPath;
import org.aksw.jena_sparql_api.sparql_path2.Nfa;
import org.aksw.jena_sparql_api.sparql_path2.NfaExecutionUtils;
import org.aksw.jena_sparql_api.sparql_path2.NfaFrontier;
import org.aksw.jena_sparql_api.sparql_path2.Pair;
import org.aksw.jena_sparql_api.sparql_path2.ParentLink;
import org.aksw.jena_sparql_api.sparql_path2.PathCompiler;
import org.aksw.jena_sparql_api.sparql_path2.PathVisitorResourceShapeBuilder;
import org.aksw.jena_sparql_api.sparql_path2.PredicateClass;
import org.aksw.jena_sparql_api.sparql_path2.TripletLookup;
import org.aksw.jena_sparql_api.sparql_path2.ValueSet;
import org.aksw.jenax.analytics.core.MappedConcept;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryQuery;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.path.Path;
import org.jgrapht.Graph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathExecutionUtils {
    private static final Logger logger = LoggerFactory.getLogger(PathExecutionUtils.class);

    public static <S, T> LookupService<Node, Set<Triplet<Node, Node>>> createLookupService(QueryExecutionFactoryQuery qef, Pair<ValueSet<Node>> predicateClass) {
        ResourceShapeBuilder rsb = new ResourceShapeBuilder();
        PathVisitorResourceShapeBuilder.apply(rsb, predicateClass, false);
        MappedConcept mc = ResourceShape.createMappedConcept((ResourceShape)rsb.getResourceShape(), null, (boolean)false);
        MapService ls = MapServiceUtils.createListServiceAcc((QueryExecutionFactoryQuery)qef, (MappedConcept)mc, (boolean)false);
        LookupServiceListService lsls = LookupServiceListService.create((MapService)ls);
        lsls = new LookupServiceFilterKey((LookupService)lsls, k -> k.isURI());
        LookupService s = lsls.mapValues((k, e) -> {
            Set<Triplet<Node, Node>> r = PathExecutionUtils.graphToTriplets(e);
            return r;
        });
        return s;
    }

    public static Set<Triplet<Node, Node>> graphToTriplets(org.apache.jena.graph.Graph graph) {
        Set result = graph.find(Node.ANY, Node.ANY, Node.ANY).mapWith(t -> new TripletImpl((Object)t.getSubject(), (Object)t.getPredicate(), (Object)t.getObject())).toSet();
        return result;
    }

    @Deprecated
    public static boolean isSimplePath(NestedPath<?, ?> path) {
        boolean result = true;
        HashSet vertices = new HashSet();
        NestedPath current = path;
        while (current != null) {
            Object vertex = current.getCurrent();
            if (vertices.contains(vertex)) {
                result = false;
                break;
            }
            vertices.add(vertex);
            current = path.getParentLink().map(ParentLink::getTarget).orElse(null);
        }
        return result;
    }

    public static void executePath(Path path, Node startNode, Node targetNode, QueryExecutionFactoryQuery qef, Function<NestedPath<Node, Node>, Boolean> pathCallback) {
        boolean abort;
        Predicate pathFilter;
        Nfa<Integer, LabeledEdge<Integer, PredicateClass>> nfa = PathCompiler.compileToNfa(path);
        Graph<Integer, LabeledEdge<Integer, PredicateClass>> nfaGraph = nfa.getGraph();
        if (logger.isDebugEnabled()) {
            logger.debug("NFA:");
            logger.debug(String.valueOf(nfa));
            for (LabeledEdge edge : nfaGraph.edgeSet()) {
                logger.debug(String.valueOf(edge));
            }
        }
        NfaFrontier frontier = new NfaFrontier();
        Function<NestedPath, Node> nodeGrouper = nestedPath -> (Node)nestedPath.getCurrent();
        NfaFrontier.addAll(frontier, nfa.getStartStates(), nodeGrouper, startNode);
        Predicate predicate = pathFilter = targetNode == null ? np -> true : np -> ((Node)np.getCurrent()).equals((Object)targetNode);
        while (!frontier.isEmpty() && !(abort = NfaExecutionUtils.collectPaths(nfa, frontier, LabeledEdgeImpl::isEpsilon, pathFilter, pathCallback))) {
            int resourceBatchSize = 100;
            TripletLookup getMatchingTriplets = (trans, vToNestedPaths) -> {
                LookupService ls = PathExecutionUtils.createLookupService(qef, (Pair)trans.getLabel()).partition(resourceBatchSize);
                Map r = ls.fetchMap((Iterable)vToNestedPaths.keySet());
                return r;
            };
            NfaFrontier nextFrontier = NfaExecutionUtils.advanceFrontier(frontier, nfaGraph, x -> x.getLabel() == null, getMatchingTriplets, nestedPath -> (Node)nestedPath.getCurrent(), p -> false);
            frontier = nextFrontier;
        }
    }
}

