/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql_path2;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.aksw.commons.util.Directed;
import org.aksw.commons.util.triplet.TripletImpl;
import org.aksw.commons.util.triplet.TripletPath;
import org.aksw.jena_sparql_api.sparql_path2.ParentLink;

public class NestedPath<V, E>
implements Serializable {
    private static final long serialVersionUID = 8761194530191829164L;
    protected ParentLink<V, E> parentLink;
    protected V current;

    public NestedPath(V current) {
        this(Optional.empty(), current);
    }

    public boolean containsVertex(Object vertex) {
        boolean result = Objects.equals(this.current, vertex) || this.getParentLink().map(ParentLink::getTarget).map(parent -> parent.containsVertex(vertex)).orElse(false) != false;
        return result;
    }

    public boolean containsEdge(Object edge, boolean reverse) {
        Directed<E> pred;
        boolean result = this.parentLink != null ? (reverse == (pred = this.parentLink.getDiProperty()).isReverse() && edge.equals(pred.getValue()) ? true : this.parentLink.getTarget().containsEdge(edge, reverse)) : false;
        return result;
    }

    public NestedPath(Optional<ParentLink<V, E>> parentLink, V current) {
        this(parentLink.isPresent() ? parentLink.get() : null, current);
    }

    public NestedPath(ParentLink<V, E> parentLink, V current) {
        this.parentLink = parentLink;
        this.current = current;
    }

    public static <V, E> NestedPath<V, E> of(NestedPath<V, E> parentPath, Directed<E> edgeLabel, V targetVertex) {
        return new NestedPath<V, E>(new ParentLink<V, E>(parentPath, edgeLabel), targetVertex);
    }

    public Optional<ParentLink<V, E>> getParentLink() {
        return Optional.ofNullable(this.parentLink);
    }

    public V getCurrent() {
        return this.current;
    }

    public boolean isCycleFree() {
        boolean result = this.asSimplePath().isCycleFree();
        return result;
    }

    public int getLength() {
        int result = this.asSimplePath().getLength();
        return result;
    }

    public TripletPath<V, Directed<E>> asSimpleDirectedPath() {
        V end = this.current;
        NestedPath<V, E> c = this;
        V start = end;
        ArrayList<TripletImpl> triplets = new ArrayList<TripletImpl>();
        while (c != null) {
            V o = c.getCurrent();
            Optional<ParentLink<V, E>> opl = c.getParentLink();
            if (!opl.isPresent()) {
                start = o;
                c = null;
                continue;
            }
            ParentLink<V, E> parentLink = opl.get();
            Directed<E> p = parentLink.getDiProperty();
            V s = parentLink.getTarget().getCurrent();
            TripletImpl triplet = new TripletImpl(s, p, o);
            triplets.add(triplet);
            c = parentLink.getTarget();
        }
        Collections.reverse(triplets);
        TripletPath result = new TripletPath(start, end, triplets);
        return result;
    }

    public TripletPath<V, E> asSimplePath() {
        V end = this.current;
        NestedPath<V, E> c = this;
        V start = end;
        ArrayList<TripletImpl> triples = new ArrayList<TripletImpl>();
        while (c != null) {
            V o = c.getCurrent();
            Optional<ParentLink<V, E>> opl = c.getParentLink();
            if (!opl.isPresent()) {
                start = o;
                c = null;
                continue;
            }
            ParentLink<V, E> parentLink = opl.get();
            Directed<E> diProperty = parentLink.getDiProperty();
            Object p = diProperty.getValue();
            V s = parentLink.getTarget().getCurrent();
            TripletImpl triple = new TripletImpl(s, p, o);
            triples.add(triple);
            c = parentLink.getTarget();
        }
        Collections.reverse(triples);
        TripletPath result = new TripletPath(start, end, triples);
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.current == null ? 0 : this.current.hashCode());
        result = 31 * result + (this.parentLink == null ? 0 : this.parentLink.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NestedPath other = (NestedPath)obj;
        if (this.current == null ? other.current != null : !this.current.equals(other.current)) {
            return false;
        }
        return !(this.parentLink == null ? other.parentLink != null : !this.parentLink.equals(other.parentLink));
    }

    public String toString() {
        return "NestedPath [parentLink=" + String.valueOf(this.parentLink) + ", current=" + String.valueOf(this.current) + "]";
    }
}

