/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql_path.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.aksw.commons.collections.generator.Generator;
import org.aksw.commons.jena.graph.GraphVarImpl;
import org.aksw.jena_sparql_api.algebra.transform.TransformReplaceConstants;
import org.aksw.jena_sparql_api.sparql_path.core.Context;
import org.aksw.jena_sparql_api.sparql_path.core.ElementTreeAnalyser;
import org.aksw.jenax.arq.util.expr.CnfUtils;
import org.aksw.jenax.arq.util.expr.ExprUtils;
import org.aksw.jenax.arq.util.var.VarGeneratorBlacklist;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.impl.Concept;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_LogicalAnd;
import org.apache.jena.sparql.expr.E_OneOf;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PathConstraintBase {
    private static final Logger logger = LoggerFactory.getLogger(PathConstraintBase.class);

    public static void getPathConstraints(Concept concept) {
        Query query = concept.asQuery();
        Op op = Algebra.compile((Query)query);
        op = Algebra.toQuadForm((Op)op);
        op = TransformReplaceConstants.transform((Op)op);
    }

    public static List<Quad> collectQuads(Element element) {
        ArrayList<Quad> result = new ArrayList<Quad>();
        Context context = new Context();
        PathConstraintBase.collectQuads(element, context, result);
        return result;
    }

    public static void collectQuads(Element element, Context context, List<Quad> result) {
        if (element instanceof ElementTriplesBlock) {
            PathConstraintBase.collectQuads((ElementTriplesBlock)element, context, result);
        } else if (element instanceof ElementGroup) {
            PathConstraintBase.collectQuads((ElementGroup)element, context, result);
        } else if (element instanceof ElementPathBlock) {
            PathConstraintBase.collectQuads((ElementPathBlock)element, context, result);
        } else {
            logger.warn("Omitting unsupported element type: " + String.valueOf(element.getClass()) + " - " + String.valueOf(element));
        }
    }

    public static void collectQuads(ElementTriplesBlock element, Context context, List<Quad> result) {
        Node graphNode = context.getGraphNode();
        for (Triple triple : element.getPattern().getList()) {
            Quad quad = new Quad(graphNode, triple);
            result.add(quad);
        }
    }

    public static void collectQuads(ElementGroup element, Context context, List<Quad> result) {
        for (Element e : element.getElements()) {
            PathConstraintBase.collectQuads(e, context, result);
        }
    }

    public static void collectQuads(ElementPathBlock element, Context context, List<Quad> result) {
        Node graphNode = context.getGraphNode();
        for (TriplePath triplePath : element.getPattern().getList()) {
            Triple triple = triplePath.asTriple();
            if (triple == null) {
                logger.warn("Omitted non-simple triple");
            }
            Quad quad = new Quad(graphNode, triple);
            result.add(quad);
        }
    }

    public static void getPathConstraints(OpProject op) {
    }

    public static void getPathConstraints(OpFilter op) {
        ExprList exprs = op.getExprs();
    }

    public static void getPathConstraints(OpQuadPattern op) {
    }

    public Concept getPathConstraintsSimple(Fragment1 concept) {
        ElementTriplesBlock element;
        ElementTreeAnalyser analyser = new ElementTreeAnalyser(concept.getElement());
        List<Quad> quads = analyser.getQuads();
        HashSet<Var> predVars = new HashSet<Var>();
        for (Quad quad : quads) {
            Node pred = quad.getPredicate();
            if (!pred.isVariable()) continue;
            Var v = (Var)pred;
            predVars.add(v);
        }
        List<Expr> exprs = analyser.getFilterExprs();
        Expr expr = ExprUtils.andifyBalanced(exprs);
        Expr cnf = CnfUtils.eval((Expr)expr);
        List clauses = CnfUtils.toClauses((Expr)cnf);
        ExprList predExprOrs = new ExprList();
        if (clauses != null) {
            for (ExprList clause : clauses) {
                Set clauseVars = clause.getVarsMentioned();
                if (!predVars.containsAll(clauseVars)) continue;
                Expr or = ExprUtils.orifyBalanced((Iterable)clause);
                predExprOrs.add(or);
            }
        }
        Expr predExpr = ExprUtils.andifyBalanced((Iterable)predExprOrs);
        GraphVarImpl model = new GraphVarImpl();
        for (Quad quad : quads) {
            model.add(quad.asTriple());
        }
        LinkedHashSet<Triple> result = new LinkedHashSet<Triple>();
        LinkedHashMap map = new LinkedHashMap();
        VarGeneratorBlacklist generator = VarGeneratorBlacklist.create((Collection)concept.getVarsMentioned());
        Function<Node, Var> nodeToVar = arg_0 -> PathConstraintBase.lambda$getPathConstraintsSimple$1(map, (Generator)generator, arg_0);
        Set types = model.find((Node)concept.getVar(), RDF.type.asNode(), Node.ANY).mapWith(Triple::getObject).filterDrop(Node::isVariable).toSet();
        if (!types.isEmpty()) {
            E_OneOf ex = ExprUtils.oneOf((Node)concept.getVar(), (Iterable)types);
            predExpr = predExpr == null ? ex : new E_LogicalAnd(predExpr, (Expr)ex);
        }
        this.createQueryForward((Graph)model, (Node)concept.getVar(), nodeToVar, result);
        if (result.isEmpty()) {
            Var s = concept.getVar();
            Collection<Triple> tps = this.createOutgoingPattern((Node)s, (Node)Vars.p);
            result.addAll(tps);
        }
        BasicPattern bgp = BasicPattern.wrap(new ArrayList<Triple>(result));
        ElementTriplesBlock triplesBlock = new ElementTriplesBlock(bgp);
        if (predExpr == null) {
            element = triplesBlock;
        } else {
            Expr e = ExprUtils.andifyBalanced((Expr[])new Expr[]{predExpr});
            ElementFilter filter = new ElementFilter(e);
            ElementGroup group = new ElementGroup();
            group.addElement((Element)triplesBlock);
            group.addElement((Element)filter);
            element = group;
        }
        Concept c = new Concept((Element)element, concept.getVar());
        logger.debug("Path query is: " + String.valueOf(c));
        return c;
    }

    public static void createQuery(Graph graph, Node src, Set<Triple> result) {
    }

    public void createQueryForward(Graph graph, Node src, Function<Node, Var> nodeToVar, Set<Triple> result) {
        Set succs = graph.find(src, Node.ANY, Node.ANY).toSet();
        for (Triple stmt : succs) {
            Node s;
            Collection<Triple> ts;
            Node p = stmt.getPredicate();
            Node o = stmt.getObject();
            if (RDF.type.asNode().equals((Object)p) || result.containsAll(ts = this.createOutgoingPattern(s = src.isVariable() || src.isBlank() ? src : (Node)nodeToVar.apply(src), p))) continue;
            result.addAll(ts);
            Set types = graph.find(o, RDF.type.asNode(), Node.ANY).mapWith(Triple::getObject).toSet();
            for (Node type : types) {
                Collection<Triple> us = this.createIngoingPattern(type, p);
                result.addAll(us);
            }
            this.createQueryForward(graph, o, nodeToVar, result);
        }
    }

    protected abstract Collection<Triple> createOutgoingPattern(Node var1, Node var2);

    protected abstract Collection<Triple> createIngoingPattern(Node var1, Node var2);

    private static /* synthetic */ Var lambda$getPathConstraintsSimple$1(Map map, Generator generator, Node n) {
        return map.computeIfAbsent(n, k -> (Var)generator.next());
    }
}

