/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql_path2;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.aksw.jena_sparql_api.sparql_path2.EdgeLabelAccessor;
import org.aksw.jena_sparql_api.sparql_path2.HalfEdge;
import org.aksw.jena_sparql_api.sparql_path2.PartialNfa;
import org.jgrapht.Graph;

public class NfaOps {
    public static <V, E, T> PartialNfa<V, T> concatenate(Graph<V, E> graph, PartialNfa<V, T> a, PartialNfa<V, T> b, EdgeLabelAccessor<E, T> edgeLabelAccessor) {
        V target = b.getStartVertex();
        for (HalfEdge<V, T> looseEnd : a.getLooseEnds()) {
            V start = looseEnd.getStartVertex();
            T edgeLabel = looseEnd.getEdgeLabel();
            Object edge = graph.addEdge(start, target);
            edgeLabelAccessor.setLabel(edge, edgeLabel);
        }
        PartialNfa<V, T> result = PartialNfa.create(a.getStartVertex(), b.getLooseEnds());
        return result;
    }

    public static <V, E, T> PartialNfa<V, T> alternate(Graph<V, E> graph, Supplier<V> vertexFactory, PartialNfa<V, T> a, PartialNfa<V, T> b) {
        V newStartVertex = vertexFactory.get();
        graph.addVertex(newStartVertex);
        graph.addEdge(newStartVertex, a.getStartVertex());
        graph.addEdge(newStartVertex, b.getStartVertex());
        ImmutableList newLooseEnds = FluentIterable.from(a.getLooseEnds()).append(b.getLooseEnds()).toList();
        PartialNfa result = PartialNfa.create(newStartVertex, newLooseEnds);
        return result;
    }

    public static <V, E, T> PartialNfa<V, T> zeroOrOne(Graph<V, E> graph, Supplier<V> vertexFactory, PartialNfa<V, T> a) {
        V newStartVertex = vertexFactory.get();
        graph.addVertex(newStartVertex);
        V oldStartVertex = a.getStartVertex();
        graph.addEdge(newStartVertex, oldStartVertex);
        ImmutableList newLooseEnds = FluentIterable.from(a.getLooseEnds()).append(Collections.singletonList(new HalfEdge<V, Object>(newStartVertex, null))).toList();
        PartialNfa result = PartialNfa.create(newStartVertex, newLooseEnds);
        return result;
    }

    public static <V, E, T> PartialNfa<V, T> zeroOrMore(Graph<V, E> graph, Supplier<V> vertexFactory, PartialNfa<V, T> a, EdgeLabelAccessor<E, T> edgeLabelAccessor) {
        V newStartVertex = vertexFactory.get();
        graph.addVertex(newStartVertex);
        V oldStartVertex = a.getStartVertex();
        graph.addEdge(newStartVertex, oldStartVertex);
        for (HalfEdge<V, T> looseEnd : a.getLooseEnds()) {
            Object edge = graph.addEdge(looseEnd.getStartVertex(), newStartVertex);
            edgeLabelAccessor.setLabel(edge, looseEnd.getEdgeLabel());
        }
        List newLooseEnds = Collections.singletonList(new HalfEdge<V, Object>(newStartVertex, null));
        PartialNfa result = PartialNfa.create(newStartVertex, newLooseEnds);
        return result;
    }

    public static <V, E, T> PartialNfa<V, T> oneOrMore(Graph<V, E> graph, Supplier<V> vertexFactory, PartialNfa<V, T> a, EdgeLabelAccessor<E, T> edgeLabelAccessor) {
        V tmpVertex = vertexFactory.get();
        graph.addVertex(tmpVertex);
        for (HalfEdge<V, T> looseEnd : a.getLooseEnds()) {
            Object edge = graph.addEdge(looseEnd.getStartVertex(), tmpVertex);
            edgeLabelAccessor.setLabel(edge, looseEnd.getEdgeLabel());
        }
        V oldStartVertex = a.getStartVertex();
        graph.addEdge(tmpVertex, oldStartVertex);
        List newLooseEnds = Collections.singletonList(new HalfEdge<V, Object>(tmpVertex, null));
        PartialNfa result = PartialNfa.create(oldStartVertex, newLooseEnds);
        return result;
    }
}

