/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql_path2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.aksw.commons.util.Directed;
import org.aksw.commons.util.list.ListUtils;
import org.aksw.commons.util.triplet.Triplet;
import org.aksw.commons.util.triplet.TripletPath;
import org.aksw.jena_sparql_api.sparql_path2.SparqlKShortestPathFinder;
import org.aksw.jena_sparql_api.sparql_path2.SparqlKShortestPathFinderMem;
import org.aksw.jenax.arq.datatype.RDFDatatypeNodeList;
import org.aksw.jenax.arq.util.node.NodeList;
import org.aksw.jenax.arq.util.node.NodeListImpl;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.factory.datasource.RDFDataSources;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryQuery;
import org.aksw.jenax.dataaccess.sparql.link.common.RDFLinkUtils;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathParser;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropFuncArgType;
import org.apache.jena.sparql.pfunction.PropertyFunctionEval;
import org.apache.jena.sparql.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFunctionPathFinder
extends PropertyFunctionEval {
    private static final Logger logger = LoggerFactory.getLogger(PropertyFunctionPathFinder.class);
    public static final String NORSE_NS = "https://w3id.org/aksw/norse#";
    public static final String DEFAULT_IRI = "https://w3id.org/aksw/norse#path.simplePaths";
    protected Function<RDFDataSource, SparqlKShortestPathFinder> dataSourceToPathFinder;

    public PropertyFunctionPathFinder(Function<RDFDataSource, SparqlKShortestPathFinder> dataSourceToPathFinder) {
        super(PropFuncArgType.PF_ARG_SINGLE, PropFuncArgType.PF_ARG_EITHER);
        this.dataSourceToPathFinder = dataSourceToPathFinder;
    }

    public QueryIterator execEvaluated(Binding binding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        Object o;
        RDFDataSource dataSource;
        Context ctx = execCxt.getContext();
        Prologue prologue = (Prologue)ctx.get(ARQConstants.sysCurrentQuery);
        if (prologue == null) {
            prologue = new Prologue(PrefixMapping.Extended);
        }
        if ((dataSource = (RDFDataSource)ctx.get(RDFLinkUtils.symRdfDataSource)) == null) {
            DatasetGraph datasetGraph = execCxt.getDataset();
            dataSource = RDFDataSources.of((DatasetGraph)datasetGraph);
        }
        Objects.requireNonNull(dataSource);
        QueryExecutionFactory qef = dataSource.asQef();
        Objects.requireNonNull(qef);
        List argList = argObject.getArgList();
        Node pathNode = (Node)ListUtils.getOrNull((List)argList, (int)0);
        Node outNode = (Node)ListUtils.getOrNull((List)argList, (int)1);
        Node targetNode = (Node)ListUtils.getOrNull((List)argList, (int)2);
        Node kNode = (Node)ListUtils.getOrNull((List)argList, (int)3);
        if (targetNode != null) {
            if (targetNode.isVariable()) {
                targetNode = binding.get((Var)targetNode);
            }
            if (targetNode != null && targetNode.isBlank()) {
                targetNode = null;
            }
        }
        Long tmpK = null;
        if (kNode != null && kNode.isLiteral() && (o = kNode.getLiteralValue()) instanceof Number) {
            tmpK = ((Number)o).longValue();
        }
        Long k = tmpK;
        Objects.requireNonNull(pathNode);
        Objects.requireNonNull(outNode);
        if (!outNode.isVariable()) {
            throw new RuntimeException("Output node must be a variable");
        }
        Var outVar = (Var)outNode;
        Node sv = argSubject.getArg();
        Node s = sv.isVariable() ? binding.get((Var)sv) : sv;
        ArrayList rdfPaths = new ArrayList();
        String pathStr = pathNode.getLiteralLexicalForm();
        Path path = PathParser.parse((String)pathStr, (Prologue)prologue);
        SparqlKShortestPathFinder pathFinder = this.dataSourceToPathFinder.apply(dataSource);
        if (pathFinder == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Using default path finder service");
            }
            pathFinder = new SparqlKShortestPathFinderMem((QueryExecutionFactoryQuery)dataSource.asQef());
        }
        Iterator<TripletPath<Node, Directed<Node>>> itPaths = pathFinder.findPaths(s, targetNode, path, k);
        Iterable tmp = () -> itPaths;
        Iterator itBindings = StreamSupport.stream(tmp.spliterator(), false).map(p -> {
            Node pNode = NodeFactory.createLiteralByValue((Object)PropertyFunctionPathFinder.pathToNodeList((TripletPath<Node, Directed<Node>>)p), (RDFDatatype)RDFDatatypeNodeList.get());
            Binding r = BindingFactory.binding((Binding)binding, (Var)outVar, (Node)pNode);
            return r;
        }).iterator();
        QueryIterator result = QueryIterPlainWrapper.create(itBindings);
        return result;
    }

    public static NodeList pathToNodeList(TripletPath<Node, Directed<Node>> path) {
        ArrayList<Node> list = new ArrayList<Node>();
        list.add((Node)path.getStart());
        for (Triplet triplet : path.getTriplets()) {
            list.add((Node)((Directed)triplet.getPredicate()).getValue());
            list.add(NodeValue.makeBoolean((boolean)((Directed)triplet.getPredicate()).isForward()).asNode());
            list.add((Node)triplet.getObject());
        }
        return new NodeListImpl(list);
    }
}

