/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql_path.impl.bidirectional;

import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.common.primitives.Ints;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.collections.generator.Generator;
import org.aksw.commons.jena.jgrapht.PseudoGraphJenaModel;
import org.aksw.jena_sparql_api.algebra.utils.AlgebraUtils;
import org.aksw.jena_sparql_api.model.QueryExecutionFactoryModel;
import org.aksw.jena_sparql_api.sparql_path.core.PathConstraintBase;
import org.aksw.jena_sparql_api.sparql_path.core.VocabPath;
import org.aksw.jenax.arq.util.exec.query.QueryExecutionUtils;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.arq.util.var.VarGeneratorBlacklist;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.factory.datasource.RDFDataSources;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.impl.Concept;
import org.aksw.jenax.sparql.fragment.impl.ConceptUtils;
import org.aksw.jenax.sparql.fragment.impl.Fragment2Impl;
import org.aksw.jenax.sparql.path.PathUtils;
import org.aksw.jenax.sparql.path.SimplePath;
import org.aksw.jenax.stmt.core.SparqlStmt;
import org.aksw.jenax.stmt.core.SparqlStmtParserImpl;
import org.aksw.jenax.stmt.core.SparqlStmtQuery;
import org.aksw.jenax.stmt.util.SparqlStmtUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.Union;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.algebra.optimize.Rewrite;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.vocabulary.OWL2;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.shortestpath.AllDirectedPaths;
import org.jgrapht.alg.shortestpath.YenKShortestPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConceptPathFinderBidirectionalUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConceptPathFinderBidirectionalUtils.class);

    public static Single<Model> createDefaultDataSummary(RDFDataSource dataSource) {
        InputStream in = ConceptPathFinderBidirectionalUtils.class.getClassLoader().getResourceAsStream("concept-path-finder.conf.sparql");
        Flowable stmts = Flowable.fromIterable(() -> {
            try {
                return SparqlStmtUtils.parse((InputStream)in, (Function)SparqlStmtParserImpl.create((Syntax)Syntax.syntaxARQ, (boolean)true));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        Single result = stmts.filter(SparqlStmt::isQuery).map(SparqlStmt::getAsQueryStmt).map(SparqlStmtQuery::getQuery).filter(q -> q.isConstructType()).map(q -> (Model)RDFDataSources.exec((RDFDataSource)dataSource, (Query)q, QueryExecution::execConstruct)).toList().map(list -> {
            Model r = ModelFactory.createDefaultModel();
            list.forEach(arg_0 -> ((Model)r).add(arg_0));
            return r;
        });
        return result;
    }

    public static Fragment1 createUnboundAwareTypeQuery(Fragment1 concept) {
        Concept result;
        if (concept.isSubjectConcept()) {
            result = Concept.parse((String)"?t { ?s a ?t }");
        } else {
            Concept fragment = Concept.parse((String)"?t { OPTIONAL { ?s a ?tmp } BIND(IF(BOUND(?tmp), ?tmp, eg:unbound) AS ?t) }", (PrefixMapping)PrefixMapping.Extended);
            result = fragment.prependOn(new Var[]{Vars.s}).with(concept).toFragment1();
        }
        return result;
    }

    public static Flowable<SimplePath> findPathsCore(RDFDataSource dataSource, Fragment1 sourceConcept, Fragment1 tmpTargetConcept, Long nPaths, Long maxLength, org.apache.jena.graph.Graph baseDataSummary, Boolean shortestPathsOnly, Boolean simplePathsOnly, Collection<BiPredicate<? super SimplePath, ? super P_Path0>> pathValidators, PathConstraintBase pathConstraint, BiFunction<? super GraphPath<RDFNode, Statement>, ? super Model, SimplePath> convertGraphPathToSparqlPath) {
        List candidateGraphPaths;
        int n;
        shortestPathsOnly = shortestPathsOnly == null ? false : shortestPathsOnly;
        simplePathsOnly = simplePathsOnly == null ? false : simplePathsOnly;
        Fragment1 targetConcept = ConceptUtils.makeDistinctFrom((Fragment1)tmpTargetConcept, (Fragment1)sourceConcept);
        logger.debug("Distinguished target concept: " + String.valueOf(targetConcept));
        Fragment1 typeConcept = ConceptPathFinderBidirectionalUtils.createUnboundAwareTypeQuery(sourceConcept);
        Query typeQuery = typeConcept.asQuery();
        logger.debug("Property query: " + String.valueOf(typeQuery));
        List types = QueryExecutionUtils.executeList(arg_0 -> ((QueryExecutionFactory)dataSource.asQef()).createQueryExecution(arg_0), (Query)typeQuery);
        logger.debug("Retrieved " + types.size() + " types");
        org.apache.jena.graph.Graph ext = GraphFactory.createDefaultGraph();
        for (Node node : types) {
            Triple triple = Triple.create((Node)VocabPath.start.asNode(), (Node)VocabPath.connectsWith.asNode(), (Node)node);
            ext.add(triple);
        }
        Union union = new Union(baseDataSummary, ext);
        Model joinSummaryGraph = ModelFactory.createModelForGraph((org.apache.jena.graph.Graph)union);
        QueryExecutionFactoryModel qefMeta = new QueryExecutionFactoryModel(joinSummaryGraph);
        Model unionModel = ModelFactory.createModelForGraph((org.apache.jena.graph.Graph)union);
        PseudoGraphJenaModel graph = new PseudoGraphJenaModel(unionModel);
        Concept targetCandidateConcept = pathConstraint.getPathConstraintsSimple(targetConcept);
        Query targetCandidateQuery = targetCandidateConcept.asQuery();
        logger.debug("TargetCandidateQuery: " + String.valueOf(targetCandidateQuery));
        List candidates = QueryExecutionUtils.executeList(arg_0 -> ((QueryExecutionFactory)qefMeta).createQueryExecution(arg_0), (Query)targetCandidateQuery);
        logger.debug("Got " + candidates.size() + " candidate target nodes");
        for (Node candidate : candidates) {
            Triple triple = Triple.create((Node)candidate, (Node)VocabPath.connectsWith.asNode(), (Node)VocabPath.end.asNode());
            ext.add(triple);
        }
        Resource startVertex = VocabPath.start;
        Resource endVertex = VocabPath.end;
        logger.info("Invoking path finder...");
        Integer _maxPathLength = maxLength == null ? null : Integer.valueOf(maxLength.intValue() + 2);
        int n2 = n = nPaths == null ? Integer.MAX_VALUE : Ints.checkedCast((long)nPaths);
        if (!shortestPathsOnly.booleanValue()) {
            AllDirectedPaths pathAlgo = new AllDirectedPaths((Graph)graph);
            candidateGraphPaths = pathAlgo.getAllPaths((Object)startVertex, (Object)endVertex, simplePathsOnly.booleanValue(), _maxPathLength);
        } else if (n == 0) {
            candidateGraphPaths = Collections.emptyList();
        } else {
            if (_maxPathLength != null) {
                throw new IllegalArgumentException("Limiting the maximum length of shortest paths was removed in jgraph; needs evaluation on how to proceed; raising this exception for now");
            }
            YenKShortestPath kShortestPaths = new YenKShortestPath((Graph)graph);
            candidateGraphPaths = kShortestPaths.getPaths((Object)startVertex, (Object)endVertex, n);
        }
        logger.info("Found " + candidateGraphPaths.size() + " candidate paths");
        Stream<SimplePath> tmp = candidateGraphPaths.stream().map(path -> (SimplePath)convertGraphPathToSparqlPath.apply((GraphPath<RDFNode, Statement>)path, (Model)unionModel)).filter(Objects::nonNull).distinct();
        if (pathValidators != null && !pathValidators.isEmpty()) {
            tmp = tmp.filter(x -> ConceptPathFinderBidirectionalUtils.testPath(x, pathValidators));
        }
        List paths = tmp.collect(Collectors.toList());
        Collections.sort(paths);
        Flowable result = Flowable.fromIterable(paths);
        return result;
    }

    public static Predicate<SimplePath> createSparqlPathValidator(RDFDataSource dataSource, Fragment1 sourceConcept, Fragment1 tmpTargetConcept) {
        Fragment1 targetConcept = ConceptUtils.makeDistinctFrom((Fragment1)tmpTargetConcept, (Fragment1)sourceConcept);
        Predicate<SimplePath> result = path -> {
            HashSet vars = new HashSet();
            vars.addAll(sourceConcept.getVarsMentioned());
            vars.addAll(targetConcept.getVarsMentioned());
            VarGeneratorBlacklist generator = VarGeneratorBlacklist.create((String)"v", vars);
            boolean r = ConceptPathFinderBidirectionalUtils.validatePath(dataSource, sourceConcept, targetConcept, path, (Generator<Var>)generator);
            return r;
        };
        return result;
    }

    public static boolean testPath(SimplePath path, Collection<BiPredicate<? super SimplePath, ? super P_Path0>> validators) {
        List steps = path.getSteps();
        int n = steps.size();
        boolean result = true;
        block0: for (int i = 0; i < n; ++i) {
            List base = steps.subList(0, i);
            P_Path0 contrib = (P_Path0)steps.get(i);
            for (BiPredicate<? super SimplePath, ? super P_Path0> validator : validators) {
                result = validator.test((SimplePath)new SimplePath(base), (P_Path0)contrib);
                if (result) continue;
                break block0;
            }
        }
        return result;
    }

    public static boolean validatePath(RDFDataSource dataSource, Fragment1 sourceConcept, Fragment1 targetConcept, SimplePath path, Generator<Var> generator) {
        List pathElements = SimplePath.pathToElements((SimplePath)path, (Var)sourceConcept.getVar(), (Var)targetConcept.getVar(), generator);
        Var sourceVar = sourceConcept.getVar();
        Var targetVar = pathElements.isEmpty() ? sourceVar : targetConcept.getVar();
        Fragment1 src = sourceConcept;
        Fragment1 tgt = targetConcept;
        Var sourceJoinVar = sourceVar;
        Var targetJoinVar = targetVar;
        if (sourceConcept.isSubjectConcept() && !targetConcept.isSubjectConcept()) {
            src = targetConcept;
            tgt = sourceConcept;
            sourceJoinVar = targetVar;
            targetJoinVar = sourceVar;
        }
        Fragment2Impl pathRelation = new Fragment2Impl(ElementUtils.groupIfNeeded((Iterable)pathElements), sourceVar, targetVar);
        Element group = pathRelation.prependOn(new Var[]{sourceJoinVar}).with(src).joinOn(new Var[]{targetJoinVar}).with(tgt).getElement();
        Query query = new Query();
        query.setQueryAskType();
        query.setQueryPattern(group);
        logger.debug("Verifying candidate with query: " + String.valueOf(query));
        boolean result = (Boolean)RDFDataSources.exec((RDFDataSource)dataSource, (Query)query, QueryExecution::execAsk);
        Rewrite rewrite = AlgebraUtils.createDefaultRewriter();
        query = QueryUtils.rewrite((Query)query, arg_0 -> ((Rewrite)rewrite).rewrite(arg_0));
        logger.debug("Verification result is [" + result + "] for " + String.valueOf(query));
        return result;
    }

    public static Boolean isFwd(Node p) {
        Boolean result = VocabPath.hasOutgoingPredicate.asNode().equals((Object)p) ? Boolean.valueOf(true) : (VocabPath.hasIngoingPredicate.asNode().equals((Object)p) ? Boolean.valueOf(false) : null);
        return result;
    }

    public static boolean isFwd3(Node p) {
        boolean result = !p.toString().contains("transition-inverse");
        return result;
    }

    public static SimplePath convertGraphPathToSparqlPath3(GraphPath<RDFNode, Statement> graphPath, Model model) {
        List el = graphPath.getEdgeList();
        List effectiveEdgeList = el.subList(1, el.size() - 1);
        SimplePath result = null;
        try {
            List steps = Streams.mapWithIndex(effectiveEdgeList.stream(), Maps::immutableEntry).map(e -> (Statement)e.getKey()).map(t -> {
                Property p = t.getPredicate();
                boolean isFwd = true;
                Resource transitionPredicate = p.getPropertyResourceValue(OWL2.annotatedProperty);
                if (transitionPredicate == null) {
                    transitionPredicate = Optional.ofNullable(p.getPropertyResourceValue(OWL2.inverseOf)).map(x -> x.getPropertyResourceValue(OWL2.annotatedProperty)).orElse(null);
                    isFwd = false;
                }
                P_Path0 step = PathUtils.createStep((Node)transitionPredicate.asNode(), (boolean)isFwd);
                return step;
            }).collect(Collectors.toList());
            result = new SimplePath(steps);
        }
        catch (Exception e2) {
            logger.debug("Harmless exception - but may indicate a bug in the algo or issue with input data: ", (Throwable)e2);
        }
        return result;
    }

    public static SimplePath convertGraphPathToSparqlPath(GraphPath<RDFNode, Statement> graphPath, Model model) {
        List el = graphPath.getEdgeList();
        List effectiveEdgeList = el.subList(1, el.size() - 1);
        SimplePath result = null;
        try {
            List steps = Streams.mapWithIndex(effectiveEdgeList.stream(), Maps::immutableEntry).filter(e -> (Long)e.getValue() % 2L == 0L).map(e -> (Statement)e.getKey()).map(t -> PathUtils.createStep((Node)t.getObject().asNode(), (boolean)ConceptPathFinderBidirectionalUtils.isFwd(t.getPredicate().asNode()))).collect(Collectors.toList());
            result = new SimplePath(steps);
        }
        catch (Exception e2) {
            logger.debug("Harmless exception - but may indicate a bug in the algo or issue with input data: ", (Throwable)e2);
        }
        return result;
    }
}

