/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql_path.impl.bidirectional;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.aksw.jena_sparql_api.sparql_path.api.ConceptPathFinder;
import org.aksw.jena_sparql_api.sparql_path.api.ConceptPathFinderBase;
import org.aksw.jena_sparql_api.sparql_path.api.ConceptPathFinderFactorySummaryBase;
import org.aksw.jena_sparql_api.sparql_path.api.ConceptPathFinderSystem;
import org.aksw.jena_sparql_api.sparql_path.api.PathSearch;
import org.aksw.jena_sparql_api.sparql_path.api.PathSearchSparqlBase;
import org.aksw.jena_sparql_api.sparql_path.core.PathConstraint3;
import org.aksw.jena_sparql_api.sparql_path.impl.bidirectional.ConceptPathFinderBidirectionalUtils;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.factory.datasource.RDFDataSources;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.impl.Concept;
import org.aksw.jenax.sparql.fragment.impl.ConceptUtils;
import org.aksw.jenax.sparql.path.SimplePath;
import org.aksw.jenax.stmt.core.SparqlStmt;
import org.aksw.jenax.stmt.core.SparqlStmtParserImpl;
import org.aksw.jenax.stmt.core.SparqlStmtQuery;
import org.aksw.jenax.stmt.util.SparqlStmtUtils;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionRemote;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.DatasetDescription;

public class ConceptPathFinderSystem3
implements ConceptPathFinderSystem {
    @Override
    public Single<Model> computeDataSummary(RDFDataSource dataSource) {
        InputStream in = ConceptPathFinderBidirectionalUtils.class.getClassLoader().getResourceAsStream("concept-path-finder-type-local.sparql");
        Flowable stmts = Flowable.fromIterable(() -> {
            try {
                return SparqlStmtUtils.parse((InputStream)in, (Function)SparqlStmtParserImpl.create((Syntax)Syntax.syntaxARQ, (boolean)true));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        Single result = stmts.filter(SparqlStmt::isQuery).map(SparqlStmt::getAsQueryStmt).map(SparqlStmtQuery::getQuery).filter(q -> q.isConstructType()).map(q -> (Model)RDFDataSources.exec((RDFDataSource)dataSource, (Query)q, QueryExecution::execConstruct)).toList().map(list -> {
            Model r = ModelFactory.createDefaultModel();
            list.forEach(arg_0 -> ((Model)r).add(arg_0));
            return r;
        });
        return result;
    }

    public ConceptPathFinderFactoryBidirectional<?> newPathFinderBuilder() {
        return new ConceptPathFinderFactoryBidirectional();
    }

    public static void main(String[] args) throws Exception {
        Model m = RDFDataMgr.loadModel((String)"/home/raven/Projects/Eclipse/faceted-browsing-benchmark-parent/faceted-browsing-benchmark-parent/faceted-browsing-benchmark-v2-parent/faceted-browsing-benchmark-v2-core/src/main/resources/path-data-simple.ttl");
        RDFDataSource dataSource = () -> RDFConnection.connect((Dataset)DatasetFactory.wrap((Model)m));
        ConceptPathFinderSystem3 system = new ConceptPathFinderSystem3();
        Model dataSummary = (Model)system.computeDataSummary(dataSource).blockingGet();
        ConceptPathFinder pathFinder = system.newPathFinderBuilder().setDataSource(dataSource).setDataSummary(dataSummary).build();
        List paths = (List)pathFinder.createSearch(ConceptUtils.createSubjectConcept(), ConceptUtils.createSubjectConcept()).setMaxLength(1L).exec().toList().blockingGet();
        System.out.println("Paths: " + String.valueOf(paths));
    }

    public static void main3(String[] args) throws Exception {
        DatasetDescription datasetDescription = new DatasetDescription();
        datasetDescription.addDefaultGraphURI("http://dbpedia.org");
        RDFDataSource dataSource = ConceptPathFinderSystem3.wrapWithDatasetAndXmlContentType("http://localhost:8890/sparql", datasetDescription);
        ConceptPathFinderSystem3 system = new ConceptPathFinderSystem3();
        Model model = (Model)system.computeDataSummary(dataSource).blockingGet();
        RDFDataMgr.write((OutputStream)new FileOutputStream("/home/raven/dbpedia-data-summary.ttl"), (Model)model, (RDFFormat)RDFFormat.TURTLE_PRETTY);
    }

    public static RDFDataSource wrapWithDatasetAndXmlContentType(String url, DatasetDescription datasetDescription) {
        RDFDataSource result = () -> RDFConnectionRemote.newBuilder().destination(url).acceptHeaderSelectQuery("application/sparql-results+xml").acceptHeaderGraph("application/n-triples").acceptHeaderDataset("application/n-quads").build();
        return result;
    }

    public static void main2(String[] args) {
        DatasetDescription datasetDescription = new DatasetDescription();
        datasetDescription.addDefaultGraphURI("http://project-hobbit.eu/benchmark/fbb2/");
        RDFDataSource dataSource = ConceptPathFinderSystem3.wrapWithDatasetAndXmlContentType("http://localhost:8890/sparql", datasetDescription);
        ConceptPathFinderSystem3 system = new ConceptPathFinderSystem3();
        Model model = (Model)system.computeDataSummary(dataSource).blockingGet();
        RDFDataMgr.write((OutputStream)System.out, (Model)model, (RDFFormat)RDFFormat.TURTLE_PRETTY);
        ConceptPathFinder conceptPathFinder = system.newPathFinderBuilder().setDataSource(dataSource).setDataSummary(model).build();
        PrefixMapping prefixes = PrefixMapping.Extended;
        PathSearch<SimplePath> pathSearch = conceptPathFinder.createSearch((Fragment1)Concept.create((String)"?src <http://data.nasa.gov/qudt/owl/qudt#unit> ?o", (String)"src", (PrefixMapping)prefixes), (Fragment1)Concept.create((String)"?tgt a <http://www.agtinternational.com/ontologies/lived#CurrentObservation>", (String)"tgt", (PrefixMapping)prefixes));
        List paths = (List)pathSearch.setMaxPathLength(3).exec().timeout(10L, TimeUnit.SECONDS).toList().blockingGet();
        System.out.println("Paths:");
        for (SimplePath path : paths) {
            System.out.println(path);
        }
        System.out.println("done.");
    }

    public static class ConceptPathFinderFactoryBidirectional<T extends ConceptPathFinderFactoryBidirectional<T>>
    extends ConceptPathFinderFactorySummaryBase<T> {
        @Override
        public ConceptPathFinder build() {
            return new ConceptPathFinderBase(this.dataSummary.getGraph(), this.dataSource){

                @Override
                public PathSearch<SimplePath> createSearch(Fragment1 sourceConcept, Fragment1 targetConcept) {
                    return new PathSearchSparqlBase(this.dataSource, sourceConcept, targetConcept){

                        @Override
                        public Flowable<SimplePath> execCore() {
                            Flowable<SimplePath> result = ConceptPathFinderBidirectionalUtils.findPathsCore(this.dataSource, this.sourceConcept, this.targetConcept, this.maxResults, this.maxLength, dataSummary, shortestPathsOnly, simplePathsOnly, pathValidators, new PathConstraint3(), ConceptPathFinderBidirectionalUtils::convertGraphPathToSparqlPath3);
                            return result;
                        }
                    };
                }
            };
        }
    }
}

