/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql_path2;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.aksw.jena_sparql_api.sparql_path2.NestedPath;

public class NfaFrontier<S, G, V, E> {
    protected Map<S, Multimap<G, NestedPath<V, E>>> paths = new HashMap<S, Multimap<G, NestedPath<V, E>>>();

    public Set<S> getCurrentStates() {
        return this.paths.keySet();
    }

    public Multimap<G, NestedPath<V, E>> getPaths(S state) {
        Multimap<G, NestedPath<V, E>> result = this.paths.get(state);
        return result;
    }

    protected Multimap<G, NestedPath<V, E>> getOrCreateStateInfo(S state) {
        HashMultimap result = this.paths.get(state);
        if (result == null) {
            result = HashMultimap.create();
            this.paths.put(state, (Multimap<G, NestedPath<HashMultimap, E>>)result);
        }
        return result;
    }

    public void add(S state, G groupKey, NestedPath<V, E> path) {
        Multimap<G, NestedPath<V, E>> nodeToPath = this.getOrCreateStateInfo(state);
        nodeToPath.put(groupKey, path);
    }

    public boolean isEmpty() {
        boolean result = this.paths.entrySet().stream().allMatch(x -> ((Multimap)x.getValue()).isEmpty());
        return result;
    }

    public static <S, G, V, E> void addAll(NfaFrontier<S, G, V, E> frontier, Set<S> states, Function<NestedPath<V, E>, G> pathGrouper, V node) {
        NfaFrontier.addAll(frontier, states, pathGrouper, Collections.singleton(node));
    }

    public static <S, G, V, E> void addAll(NfaFrontier<S, G, V, E> frontier, Set<S> states, Function<NestedPath<V, E>, G> pathGrouper, Collection<V> nodes) {
        states.forEach(state -> nodes.forEach(node -> {
            NestedPath rdfPath = new NestedPath(node);
            Object groupKey = pathGrouper.apply(rdfPath);
            frontier.add(state, groupKey, rdfPath);
        }));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.paths == null ? 0 : this.paths.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NfaFrontier other = (NfaFrontier)obj;
        return !(this.paths == null ? other.paths != null : !this.paths.equals(other.paths));
    }

    public String toString() {
        return "Frontier [paths=" + String.valueOf(this.paths) + "]";
    }
}

