/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api_sparql_path2.playground;

import com.google.common.collect.Lists;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.aksw.commons.util.Directed;
import org.aksw.commons.util.triplet.Triplet;
import org.aksw.commons.util.triplet.TripletPath;
import org.aksw.jena_sparql_api.sparql_path2.Nfa;
import org.aksw.jena_sparql_api.sparql_path2.NfaExecutionUtils;
import org.aksw.jena_sparql_api.sparql_path2.Pair;
import org.aksw.jena_sparql_api.sparql_path2.ValueSet;
import org.aksw.jena_sparql_api_sparql_path2.playground.NfaDijkstra;
import org.aksw.jena_sparql_api_sparql_path2.playground.NfaSuccessor;

public class YensKShortestPaths {
    public static <S, T, V, E> List<TripletPath<Map.Entry<S, V>, Directed<E>>> findPaths(Nfa<S, T> nfa, Predicate<T> isEpsilon, Function<T, ? extends Pair<ValueSet<V>>> transToVertexClass, Function<Pair<ValueSet<V>>, ? extends Function<? super Iterable<V>, Map<V, Set<Triplet<V, E>>>>> createTripletLookupService, V source, V target, int maxK) {
        NfaSuccessor successors = new NfaSuccessor(nfa, isEpsilon, transToVertexClass, createTripletLookupService);
        HashSet starts = new HashSet();
        nfa.getStartStates().forEach(s -> starts.add(new AbstractMap.SimpleEntry<Object, Object>(s, source)));
        List<TripletPath<Map.Entry<S, V>, Directed<E>>> result = YensKShortestPaths.findPaths(successors, starts, e -> {
            Object state = e.getKey();
            Object vertex = e.getValue();
            boolean isAcceptingState = NfaExecutionUtils.isFinalState(nfa, state, isEpsilon);
            boolean isTargetVertex = target.equals(vertex);
            boolean r = isAcceptingState && isTargetVertex;
            return r;
        }, maxK);
        return result;
    }

    public static <V, E> List<TripletPath<V, Directed<E>>> findPaths(Function<? super Iterable<V>, Map<V, Set<Triplet<V, Directed<E>>>>> successors, Collection<V> sources, Predicate<V> isTarget, int maxK) {
        ArrayList<TripletPath<V, Directed<Object>>> A = new ArrayList<TripletPath<V, Directed<Object>>>();
        ArrayList<TripletPath> B = new ArrayList<TripletPath>();
        HashSet<Triplet> removedTriplets = new HashSet<Triplet>();
        HashSet removedNodes = new HashSet();
        Function<Iterable, Map> succ = rawNodes -> {
            Set nodes = Lists.newArrayList((Iterable)rawNodes).stream().filter(x -> !removedNodes.contains(x)).collect(Collectors.toSet());
            Map tmp = (Map)successors.apply(nodes);
            tmp.entrySet().removeIf(removedNodes::contains);
            tmp.entrySet().forEach(e -> {
                Set ts = (Set)e.getValue();
                ts.removeIf(triplet -> {
                    boolean skip = removedTriplets.contains(triplet) || removedNodes.contains(triplet.getSubject()) || removedNodes.contains(triplet.getObject());
                    return skip;
                });
            });
            return tmp;
        };
        TripletPath<V, Directed<E>> path = NfaDijkstra.dijkstra(successors, sources, isTarget);
        if (path != null) {
            A.add(path);
            for (int k = 1; k < maxK; ++k) {
                TripletPath ak_1 = (TripletPath)A.get(k - 1);
                int akl = ak_1.getLength();
                for (int i = 0; i < akl; ++i) {
                    if (k == 3 && i == 2) {
                        System.out.println("DEBUG condition");
                    }
                    Object spurNode = ak_1.getNode(i);
                    TripletPath rootPath = ak_1.subPath(0, i);
                    for (TripletPath tripletPath : A) {
                        TripletPath subPath;
                        if (tripletPath.getLength() < rootPath.getLength() || !rootPath.equals((Object)(subPath = tripletPath.subPath(0, i)))) continue;
                        Triplet triplet = (Triplet)tripletPath.getTriplets().get(i);
                        removedTriplets.add(triplet);
                    }
                    Set rootPathNodes = rootPath.getNodeSet();
                    rootPathNodes.remove(spurNode);
                    removedNodes.addAll(rootPathNodes);
                    TripletPath tripletPath = NfaDijkstra.dijkstra(succ, Collections.singleton(spurNode), isTarget);
                    if (tripletPath != null) {
                        TripletPath totalPath = rootPath.concat(tripletPath);
                        System.out.println("GOT TOTAL PATH: " + String.valueOf(totalPath));
                        B.add(totalPath);
                    }
                    removedNodes.clear();
                    removedTriplets.clear();
                }
                if (B.isEmpty()) break;
                int l = B.size() - 1;
                TripletPath chosenPath = (TripletPath)B.remove(l);
                A.add(chosenPath);
            }
        }
        return A;
    }
}

