/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql_path2;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.aksw.commons.util.Directed;
import org.aksw.jena_sparql_api.sparql_path2.NestedPath;
import org.aksw.jena_sparql_api.sparql_path2.ParentLink;
import org.jgrapht.Graph;

public class SimplePathBfsIterator<V, E>
extends AbstractIterator<List<NestedPath<V, E>>> {
    protected Graph<V, E> graph;
    protected List<NestedPath<V, E>> frontier;
    protected Predicate<NestedPath<V, E>> isAccepted;

    public SimplePathBfsIterator(Graph<V, E> graph, Collection<V> start, Predicate<NestedPath<V, E>> isAccepted) {
        this.graph = graph;
        this.frontier = start.stream().map(item -> new NestedPath(item)).collect(Collectors.toList());
        this.isAccepted = isAccepted;
    }

    public static <V, E> List<NestedPath<V, E>> collectPaths(List<NestedPath<V, E>> paths, Predicate<NestedPath<V, E>> predicate) {
        List<NestedPath<V, E>> result = paths.stream().filter(predicate).collect(Collectors.toList());
        return result;
    }

    public static <V, E> List<NestedPath<V, E>> advanceFrontier(Graph<V, E> graph, Collection<NestedPath<V, E>> paths) {
        ArrayList<NestedPath<V, NestedPath<Object, E>>> result = new ArrayList<NestedPath<V, NestedPath<Object, E>>>();
        for (NestedPath<V, E> path : paths) {
            V current = path.getCurrent();
            Set edges = graph.outgoingEdgesOf(current);
            for (Object edge : edges) {
                boolean isCycle = path.containsEdge(edge, false);
                Object v = graph.getEdgeTarget(edge);
                if (isCycle) continue;
                NestedPath<Object, E> nextPath = new NestedPath<Object, E>(new ParentLink<V, E>(path, new Directed(edge, false)), v);
                result.add(nextPath);
            }
        }
        return result;
    }

    protected List<NestedPath<V, E>> computeNext() {
        List result;
        block1: {
            do {
                result = SimplePathBfsIterator.collectPaths(this.frontier, this.isAccepted);
                this.frontier = SimplePathBfsIterator.advanceFrontier(this.graph, this.frontier);
                if (!result.isEmpty()) break block1;
            } while (!this.frontier.isEmpty());
            result = (List)this.endOfData();
        }
        return result;
    }
}

