/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api_sparql_path2.playground;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.aksw.commons.collections.MultiMaps;
import org.aksw.commons.util.Directed;
import org.aksw.commons.util.triplet.Triplet;
import org.aksw.commons.util.triplet.TripletImpl;
import org.aksw.commons.util.triplet.TripletPath;
import org.aksw.jena_sparql_api.sparql_path2.JGraphTUtils;
import org.aksw.jena_sparql_api.sparql_path2.Nfa;
import org.aksw.jena_sparql_api.sparql_path2.NfaExecutionUtils;
import org.aksw.jena_sparql_api.sparql_path2.Pair;
import org.aksw.jena_sparql_api.sparql_path2.ValueSet;
import org.aksw.jena_sparql_api.sparql_path2.VertexClass;
import org.jgrapht.Graph;

public class NfaDijkstra {
    public static <T, V, E> boolean isOrigin(Pair<ValueSet<V>> vertexClass, V vertex, Triplet<V, E> triplet) {
        List dirs = TripletImpl.getDirections(triplet, vertex);
        boolean result = dirs.stream().anyMatch(dir -> {
            int index = dir == false ? 0 : 1;
            ValueSet valueSet = (ValueSet)vertexClass.get(index);
            Object p = triplet.getPredicate();
            boolean r = valueSet.contains(p);
            return r;
        });
        return result;
    }

    public static <V, E> TripletPath<V, Directed<E>> dijkstra(Function<? super Iterable<V>, Map<V, Set<Triplet<V, Directed<E>>>>> successors, Collection<V> sources, Predicate<V> isTarget) {
        TripletPath result;
        HashMap<Object, Integer> vertexToCost = new HashMap<Object, Integer>();
        HashMap<Object, Triplet<V, Directed<E>>> vertexToMinCostPredecessor = new HashMap<Object, Triplet<V, Directed<E>>>();
        HashSet<V> open = new HashSet<V>();
        HashSet<V> seen = new HashSet<V>();
        for (V source : sources) {
            vertexToCost.put(source, 0);
        }
        open.addAll(sources);
        Object reachedTargetVertex = null;
        while (!open.isEmpty()) {
            seen.addAll(open);
            HashSet<Object> next = new HashSet<Object>();
            Map<V, Set<Triplet<V, Directed<E>>>> succs = successors.apply(open);
            for (Map.Entry<V, Set<Triplet<V, Directed<E>>>> entry : succs.entrySet()) {
                V v = entry.getKey();
                int baseCost = (Integer)vertexToCost.get(v);
                int thisCost = baseCost + 1;
                for (Triplet<V, Directed<E>> triplet : entry.getValue()) {
                    Object succ = triplet.getObject();
                    next.add(succ);
                    Integer targetMinCost = vertexToCost.getOrDefault(succ, null);
                    if (targetMinCost != null && thisCost >= targetMinCost) continue;
                    vertexToCost.put(succ, thisCost);
                    vertexToMinCostPredecessor.put(succ, triplet);
                    boolean isTargetVertex = isTarget.test(succ);
                    if (!isTargetVertex) continue;
                    reachedTargetVertex = succ;
                }
            }
            next.removeAll(seen);
            open = next;
        }
        System.out.println("Backtracking for: " + String.valueOf(reachedTargetVertex));
        if (reachedTargetVertex != null) {
            Object o;
            ArrayList<TripletImpl> path = new ArrayList<TripletImpl>();
            Object end = o = reachedTargetVertex;
            while (o != null && !sources.contains(o)) {
                Triplet predecessor = (Triplet)vertexToMinCostPredecessor.get(o);
                if (predecessor == null) {
                    System.out.println("should not happen");
                }
                Object s = predecessor.getSubject();
                Directed dp = (Directed)predecessor.getPredicate();
                path.add(new TripletImpl(s, (Object)dp, o));
                o = s;
            }
            Collections.reverse(path);
            result = new TripletPath(o, end, path);
        } else {
            result = null;
        }
        return result;
    }

    public static <S, T, V, E> TripletPath<V, E> dijkstra(Nfa<S, T> nfa, Predicate<T> isEpsilon, Function<T, Pair<ValueSet<V>>> transToVertexClass, Function<Pair<ValueSet<V>>, Function<? super Iterable<V>, Map<V, Set<Triplet<V, E>>>>> createTripletLookupService, V source, V target) {
        TripletPath result;
        HashMap<Map.Entry, Integer> vertexToCost = new HashMap<Map.Entry, Integer>();
        HashMap<Map.Entry, Triplet> vertexToMinCostPredecessor = new HashMap<Map.Entry, Triplet>();
        HashSet<Map.Entry<Object, V>> open = new HashSet<Map.Entry<S, V>>();
        HashSet<Map.Entry<S, V>> seen = new HashSet<Map.Entry<S, V>>();
        for (S s : nfa.getStartStates()) {
            AbstractMap.SimpleEntry<S, V> e = new AbstractMap.SimpleEntry<S, V>(s, source);
            open.add(e);
            vertexToCost.put(e, 0);
        }
        Map.Entry reachedTargetVertex = null;
        while (!open.isEmpty()) {
            seen.addAll(open);
            HashSet<Map.Entry> next = new HashSet<Map.Entry>();
            Map<Map.Entry<S, V>, Set<Triplet<Map.Entry<S, V>, Directed<E>>>> succs = NfaDijkstra.getSuccessors(nfa, isEpsilon, transToVertexClass, createTripletLookupService, open);
            for (Map.Entry<Map.Entry<S, V>, Set<Triplet<Map.Entry<S, V>, Directed<E>>>> entry : succs.entrySet()) {
                Map.Entry<S, V> v = entry.getKey();
                int baseCost = (Integer)vertexToCost.get(v);
                int thisCost = baseCost + 1;
                for (Triplet<Map.Entry<S, V>, Directed<E>> triplet : entry.getValue()) {
                    Map.Entry succ = (Map.Entry)triplet.getObject();
                    next.add(succ);
                    Object state = succ.getKey();
                    Object vertex = succ.getValue();
                    Integer targetMinCost = vertexToCost.getOrDefault(succ, null);
                    if (targetMinCost != null && thisCost >= targetMinCost) continue;
                    vertexToCost.put(succ, thisCost);
                    vertexToMinCostPredecessor.put(succ, TripletImpl.makeUndirected(triplet));
                    boolean isAcceptingState = NfaExecutionUtils.isFinalState(nfa, state, isEpsilon);
                    boolean isTargetVertex = target.equals(vertex);
                    if (!isAcceptingState || !isTargetVertex) continue;
                    reachedTargetVertex = succ;
                }
            }
            next.removeAll(seen);
            open = next;
        }
        System.out.println("Backtracking for: " + String.valueOf(reachedTargetVertex));
        if (reachedTargetVertex != null) {
            ArrayList<TripletImpl> path = new ArrayList<TripletImpl>();
            Map.Entry eo = reachedTargetVertex;
            while (eo != null) {
                Object start = eo.getValue();
                Object state = eo.getKey();
                boolean isStartState = NfaExecutionUtils.isStartState(nfa, state, isEpsilon);
                boolean isStartVertex = source.equals(start);
                if (isStartVertex && isStartState) break;
                Triplet predecessor = (Triplet)vertexToMinCostPredecessor.get(eo);
                if (predecessor == null) {
                    System.out.println("should not happen");
                }
                Map.Entry es = (Map.Entry)predecessor.getSubject();
                Object s = es.getValue();
                Object p = predecessor.getPredicate();
                Object o = eo.getValue();
                path.add(new TripletImpl(s, p, o));
                eo = es;
            }
            Collections.reverse(path);
            result = new TripletPath(source, target, path);
        } else {
            result = null;
        }
        return result;
    }

    public static <S, T, V, E> Map<Map.Entry<S, V>, Set<Triplet<Map.Entry<S, V>, Directed<E>>>> getSuccessors(Nfa<S, T> nfa, Predicate<T> isEpsilon, Function<T, ? extends Pair<ValueSet<V>>> transToVertexClass, Function<Pair<ValueSet<V>>, ? extends Function<? super Iterable<V>, Map<V, Set<Triplet<V, E>>>>> createTripletLookupService, Iterable<Map.Entry<S, V>> stateVertexPairs) {
        HashMultimap open = HashMultimap.create();
        HashMap result = new HashMap();
        stateVertexPairs.forEach(arg_0 -> NfaDijkstra.lambda$getSuccessors$1((Multimap)open, arg_0));
        Graph nfaGraph = nfa.getGraph();
        for (Map.Entry e : open.asMap().entrySet()) {
            Object state = e.getKey();
            Collection vertices = (Collection)e.getValue();
            Set transitions = JGraphTUtils.resolveTransitions(nfaGraph, isEpsilon, state, false);
            Pair vertexClass = transitions.stream().reduce(new VertexClass(), (a, b) -> (Pair)transToVertexClass.apply(b), (a, b) -> VertexClass.union(a, b));
            Function<Iterable<V>, Map<V, Set<Triplet<V, E>>>> tripletService = createTripletLookupService.apply(vertexClass);
            Map<V, Set<Triplet<V, E>>> vToTriplets = tripletService.apply(vertices);
            vToTriplets.entrySet().forEach(vToTriplet -> {
                Object v = vToTriplet.getKey();
                AbstractMap.SimpleEntry source = new AbstractMap.SimpleEntry(state, v);
                transitions.stream().forEach(t -> {
                    Pair vc = (Pair)transToVertexClass.apply(t);
                    ((Set)vToTriplet.getValue()).stream().forEach(rawTriplet -> {
                        Triplet triplet = TripletImpl.makeDirected((Triplet)rawTriplet, (Object)v);
                        Object targetVertex = triplet.getObject();
                        boolean isOrig = NfaDijkstra.isOrigin(vc, v, rawTriplet);
                        if (isOrig) {
                            Object targetState = nfaGraph.getEdgeTarget(t);
                            AbstractMap.SimpleEntry<Object, Object> target = new AbstractMap.SimpleEntry<Object, Object>(targetState, targetVertex);
                            TripletImpl trip = new TripletImpl((Object)source, (Object)((Directed)triplet.getPredicate()), target);
                            MultiMaps.put((Map)result, (Object)source, (Object)trip);
                        }
                    });
                });
            });
        }
        return result;
    }

    private static /* synthetic */ void lambda$getSuccessors$1(Multimap open, Map.Entry e) {
        open.put(e.getKey(), e.getValue());
    }
}

