/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql_path.core.algorithm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.aksw.commons.collections.generator.Generator;
import org.aksw.commons.util.string.StringUtils;
import org.aksw.jena_sparql_api.model.QueryExecutionFactoryModel;
import org.aksw.jena_sparql_api.sparql_path.core.PathConstraint;
import org.aksw.jena_sparql_api.sparql_path.core.VocabPath;
import org.aksw.jena_sparql_api.sparql_path.core.algorithm.GraphPathComparator;
import org.aksw.jenax.arq.util.exec.query.QueryExecutionUtils;
import org.aksw.jenax.arq.util.var.VarGeneratorBlacklist;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryQuery;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.impl.Concept;
import org.aksw.jenax.sparql.fragment.impl.ConceptUtils;
import org.aksw.jenax.sparql.path.PathUtils;
import org.aksw.jenax.sparql.path.SimplePath;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_OneOf;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.shortestpath.DijkstraShortestPath;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.GraphWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConceptPathFinder {
    private static final Logger logger = LoggerFactory.getLogger(ConceptPathFinder.class);

    public static ResultSet getPropertyAdjacency(QueryExecutionFactoryQuery qef) {
        Query query = QueryFactory.create((String)"Select Distinct ?x ?y { ?a ?x ?b . ?b ?y ?c . Filter(!regex(str(?x), '^http://www.w3.org/1999/02/22-rdf-syntax-ns#_') && !regex(str(?y), '^http://www.w3.org/1999/02/22-rdf-syntax-ns#_')) }");
        QueryExecution qe = qef.createQueryExecution(query);
        ResultSet result = qe.execSelect();
        return result;
    }

    @Deprecated
    public static Model createJoinSummary(QueryExecutionFactory qef) {
        QueryExecution qe = qef.createQueryExecution("Select ?x ?y { ?x <" + VocabPath.joinsWith.getURI() + "> ?y }");
        ResultSet rs = qe.execSelect();
        Model result = ConceptPathFinder.processJoinSummaryQuery(rs);
        return result;
    }

    public static Model createDefaultJoinSummaryModel(QueryExecutionFactoryQuery qef) {
        ResultSet rs = ConceptPathFinder.getPropertyAdjacency(qef);
        Model result = ConceptPathFinder.processJoinSummaryQuery(rs);
        return result;
    }

    public static Model processJoinSummaryQuery(ResultSet rs) {
        Model joinSummaryModel = ModelFactory.createDefaultModel();
        while (rs.hasNext()) {
            QuerySolution qs = rs.next();
            Resource x = qs.getResource("x");
            Resource y = qs.getResource("y");
            joinSummaryModel.add(x, VocabPath.joinsWith, (RDFNode)y);
        }
        logger.debug("Join summary model contains " + joinSummaryModel.size() + " triples");
        return joinSummaryModel;
    }

    public static List<SimplePath> findPaths(QueryExecutionFactoryQuery qef, Fragment1 sourceConcept, Fragment1 tmpTargetConcept, Long nPaths, Long maxHops) {
        Model joinSummaryModel = ConceptPathFinder.createDefaultJoinSummaryModel(qef);
        List<SimplePath> result = ConceptPathFinder.findPaths(qef, sourceConcept, tmpTargetConcept, nPaths, maxHops, joinSummaryModel);
        return result;
    }

    public static List<SimplePath> findPaths(QueryExecutionFactoryQuery qef, Fragment1 sourceConcept, Fragment1 tmpTargetConcept, Long nPaths, Long maxHops, Model joinSummaryModel) {
        Fragment1 propertyConcept;
        Fragment1 targetConcept = ConceptUtils.makeDistinctFrom((Fragment1)tmpTargetConcept, (Fragment1)sourceConcept);
        logger.debug("Distinguished target concept: " + String.valueOf(targetConcept));
        if (sourceConcept.isSubjectConcept()) {
            List elements = sourceConcept.getElements();
            ElementTriplesBlock etb = (ElementTriplesBlock)elements.get(0);
            Triple triple = etb.getPattern().get(0);
            Var s = (Var)triple.getSubject();
            Var p = (Var)triple.getPredicate();
            ElementFilter pFilter = new ElementFilter((Expr)new E_Equals((Expr)new ExprVar(p), (Expr)NodeValue.makeNode((Node)RDF.type.asNode())));
            Var o = (Var)triple.getObject();
            ExprList oExprs = new ExprList();
            oExprs.add((Expr)NodeValue.makeNode((Node)RDF.Property.asNode()));
            oExprs.add((Expr)NodeValue.makeNode((Node)OWL.DatatypeProperty.asNode()));
            oExprs.add((Expr)NodeValue.makeNode((Node)OWL.ObjectProperty.asNode()));
            ElementFilter oFilter = new ElementFilter((Expr)new E_OneOf((Expr)new ExprVar(o), oExprs));
            ArrayList<Object> newElements = new ArrayList<Object>();
            newElements.add(etb);
            newElements.add(pFilter);
            newElements.add(oFilter);
            propertyConcept = new Concept(newElements, s);
        } else {
            propertyConcept = ConceptUtils.createPredicateQuery((Fragment1)sourceConcept);
        }
        Query propertyQuery = propertyConcept.asQuery();
        logger.debug("Property query: " + String.valueOf(propertyQuery));
        List nodes = QueryExecutionUtils.executeList(arg_0 -> ((QueryExecutionFactoryQuery)qef).createQueryExecution(arg_0), (Query)propertyQuery);
        logger.debug("Retrieved " + nodes.size() + " properties");
        for (Node node : nodes) {
            Triple triple = Triple.create((Node)VocabPath.start.asNode(), (Node)VocabPath.joinsWith.asNode(), (Node)node);
            Statement stmt = joinSummaryModel.asStatement(triple);
            joinSummaryModel.add(stmt);
        }
        QueryExecutionFactoryModel qefMeta = new QueryExecutionFactoryModel(joinSummaryModel);
        Concept targetCandidateConcept = PathConstraint.getPathConstraintsSimple(targetConcept);
        Query targetCandidateQuery = targetCandidateConcept.asQuery();
        logger.debug("TargetCandidateQuery: " + String.valueOf(targetCandidateQuery));
        List candidates = QueryExecutionUtils.executeList(arg_0 -> ((QueryExecutionFactory)qefMeta).createQueryExecution(arg_0), (Query)targetCandidateQuery);
        logger.debug("Got " + candidates.size() + " candidates: " + String.valueOf(candidates));
        Node startVertex = VocabPath.start.asNode();
        DefaultDirectedGraph graph = new DefaultDirectedGraph(DefaultEdge.class);
        graph.addVertex((Object)startVertex);
        StmtIterator itStmt = joinSummaryModel.listStatements(null, VocabPath.joinsWith, (RDFNode)null);
        while (itStmt.hasNext()) {
            Statement stmt = (Statement)itStmt.next();
            Node s = stmt.getSubject().asNode();
            Node o = stmt.getObject().asNode();
            graph.addVertex((Object)s);
            graph.addVertex((Object)o);
            graph.addEdge((Object)s, (Object)o);
        }
        logger.debug("Graph Metrics: " + graph.vertexSet().size() + " vertices, " + graph.edgeSet().size() + " edges; based on (at least) " + joinSummaryModel.size() + " triples");
        ArrayList<GraphPath> candidateGraphPaths = new ArrayList<GraphPath>();
        int i = 0;
        for (Object candidate : candidates) {
            logger.debug("Processing candidate " + ++i + "/" + candidates.size() + ": " + String.valueOf(candidate) + " (nPaths = " + nPaths + ", maxHops = " + maxHops + ")");
            if (startVertex.equals(candidate)) {
                GraphPath graphPath = new GraphWalk((Graph)graph, (Object)startVertex, candidate, new ArrayList(), 0.0);
                candidateGraphPaths.add(graphPath);
                continue;
            }
            DijkstraShortestPath dijkstraShortestPath = new DijkstraShortestPath((Graph)graph);
            GraphPath tmp = dijkstraShortestPath.getPath((Object)startVertex, candidate);
            if (tmp == null) continue;
            candidateGraphPaths.add(tmp);
        }
        Collections.sort(candidateGraphPaths, new GraphPathComparator());
        ArrayList<SimplePath> paths = new ArrayList<SimplePath>();
        for (GraphPath graphPath : candidateGraphPaths) {
            Node current = (Node)graphPath.getStartVertex();
            ArrayList<P_Path0> steps = new ArrayList<P_Path0>();
            for (DefaultEdge edge : graphPath.getEdgeList()) {
                boolean isFwd;
                Node source = (Node)graph.getEdgeSource((Object)edge);
                Node target = (Node)graph.getEdgeTarget((Object)edge);
                if (current.equals((Object)source)) {
                    current = target;
                    isFwd = true;
                } else if (current.equals((Object)target)) {
                    current = source;
                    isFwd = false;
                } else {
                    throw new RuntimeException("Should not happen");
                }
                P_Path0 p_Path0 = PathUtils.createStep((Node)current, (boolean)isFwd);
                steps.add(p_Path0);
            }
            SimplePath path = new SimplePath(steps);
            paths.add(path);
        }
        HashSet varNames = new HashSet();
        varNames.addAll(sourceConcept.getVarsMentioned());
        varNames.addAll(targetConcept.getVarsMentioned());
        VarGeneratorBlacklist generator = VarGeneratorBlacklist.create((String)"v", varNames);
        ArrayList<SimplePath> result = new ArrayList<SimplePath>();
        for (SimplePath path : paths) {
            List pathElements = SimplePath.pathToElements((SimplePath)path, (Var)sourceConcept.getVar(), (Var)targetConcept.getVar(), (Generator)generator);
            ArrayList<ElementFilter> tmp = new ArrayList<ElementFilter>();
            if (!sourceConcept.isSubjectConcept()) {
                tmp.addAll(sourceConcept.getElements());
            }
            tmp.addAll(targetConcept.getElements());
            tmp.addAll(pathElements);
            if (pathElements.isEmpty() && !sourceConcept.getVar().equals((Object)targetConcept.getVar()) && !sourceConcept.isSubjectConcept()) {
                tmp.add(new ElementFilter((Expr)new E_Equals((Expr)new ExprVar(sourceConcept.getVar()), (Expr)new ExprVar(targetConcept.getVar()))));
            }
            ElementGroup group = new ElementGroup();
            for (Element element : tmp) {
                group.addElement(element);
            }
            Query query = new Query();
            query.setQueryAskType();
            query.setQueryPattern((Element)group);
            logger.debug("Verifying candidate with query: " + String.valueOf(query));
            QueryExecution queryExecution = qef.createQueryExecution(query);
            boolean isCandidate = queryExecution.execAsk();
            logger.debug("Verification result is [" + isCandidate + "] for " + String.valueOf(query));
            if (!isCandidate) continue;
            result.add(path);
        }
        return result;
    }

    public static Model createModel(List<SimplePath> paths) {
        Model result = ModelFactory.createDefaultModel();
        Resource Path2 = ResourceFactory.createResource((String)"http://ns.aksw.org/jassa/ontology/Path");
        Property length = ResourceFactory.createProperty((String)"http://ns.aksw.org/jassa/ontology/pathLength");
        boolean i = false;
        for (SimplePath path : paths) {
            String pathStr = path.toPathString();
            Resource s = result.createResource("http://example.org/path/" + StringUtils.urlEncode((String)pathStr));
            Literal o = result.createLiteral(pathStr);
            Literal l = result.createTypedLiteral(path.getSteps().size());
            result.add(s, RDF.type, (RDFNode)Path2);
            result.add(s, RDFS.label, (RDFNode)o);
            result.add(s, length, (RDFNode)l);
        }
        return result;
    }
}

