/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.ron;

import org.aksw.commons.path.core.Path;
import org.aksw.jenax.path.core.PathOpsPP;
import org.aksw.jenax.path.core.PathPP;
import org.aksw.jenax.ron.ParentLink;
import org.aksw.jenax.ron.ParentLinkArray;
import org.aksw.jenax.ron.ParentLinkObject;
import org.aksw.jenax.ron.RdfArray;
import org.aksw.jenax.ron.RdfElementVisitor;
import org.aksw.jenax.ron.RdfLiteral;
import org.aksw.jenax.ron.RdfNull;
import org.aksw.jenax.ron.RdfObject;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.util.NodeFactoryExtra;

public interface RdfElement {
    default public boolean isArray() {
        return this instanceof RdfArray;
    }

    default public RdfArray getAsArray() {
        return (RdfArray)this;
    }

    default public boolean isObject() {
        return this instanceof RdfObject;
    }

    default public RdfObject getAsObject() {
        return (RdfObject)this;
    }

    default public boolean isLiteral() {
        return this instanceof RdfLiteral;
    }

    default public RdfLiteral getAsLiteral() {
        return (RdfLiteral)this;
    }

    default public boolean isNull() {
        return this instanceof RdfNull;
    }

    default public RdfNull asNull() {
        return (RdfNull)this;
    }

    public <T> T accept(RdfElementVisitor<T> var1);

    public ParentLink getParent();

    default public void unlinkFromParent() {
        ParentLink link = this.getParent();
        if (link != null) {
            if (link.isObjectLink()) {
                ParentLinkObject objLink = link.asObjectLink();
                P_Path0 key = objLink.getKey();
                objLink.getParent().remove(key);
            } else if (link.isArrayLink()) {
                ParentLinkArray arrLink = link.asArrayLink();
                int index = arrLink.getIndex();
                arrLink.getParent().set(index, new RdfNull());
            } else {
                throw new RuntimeException("Unknown parent link type: " + String.valueOf(link.getClass()));
            }
        }
    }

    default public RdfElement getRoot() {
        ParentLink link = this.getParent();
        RdfElement result = link == null ? this : link.getParent().getRoot();
        return result;
    }

    default public RdfElement resolve(PathPP path) {
        RdfElement result;
        if (path.isAbsolute()) {
            PathPP relPath = (PathPP)path.relativize((Path)PathPP.newAbsolutePath((P_Path0[])new P_Path0[0]));
            RdfElement root = this.getRoot();
            result = root.resolve(relPath);
        } else {
            int n = path.getNameCount();
            if (n == 0) {
                result = this;
            } else {
                RdfElement next;
                PathPP segment = (PathPP)path.getName(0);
                P_Path0 p = (P_Path0)segment.toSegment();
                PathPP rest = (PathPP)path.subpath(1, n);
                if (PathOpsPP.PARENT.equals((Object)p)) {
                    next = this.getParent().getParent();
                } else if (PathOpsPP.SELF.equals((Object)p)) {
                    next = this;
                } else if (this.isObject()) {
                    next = this.getAsObject().get(p);
                } else if (this.isArray()) {
                    if (!p.isForward()) {
                        throw new RuntimeException("Cannot resolve backward step on array");
                    }
                    int index = NodeFactoryExtra.nodeToInt((Node)p.getNode());
                    next = this.getAsArray().get(index);
                } else {
                    throw new RuntimeException("Cannot resolve path (other than PARENT and SELF) on literal");
                }
                result = next.resolve(rest);
            }
        }
        return result;
    }
}

