/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.rdf.jsonld;

import org.aksw.jenax.io.rdf.json.JsonProvider;
import org.apache.jena.graph.Node;

public class JsonLdAccessorImpl {
    protected JsonProvider jsonProvider;

    public Object getOrCreateContext(Object json) {
        Object result = this.jsonProvider.getOrCreateObject(json, "@context");
        return result;
    }

    public void declareProperty(Object json, String fieldName, Node property, boolean isForward) {
        Object context = this.getOrCreateContext(json);
        Object fieldMetaData = this.jsonProvider.computePropertyIfAbsent(context, fieldName, k -> this.jsonProvider.newObject());
        if (!this.jsonProvider.isObject(fieldMetaData)) {
            throw new RuntimeException("Context is not an object");
        }
        String iriStr = property.getURI();
        Object iriValue = this.jsonProvider.newLiteral(iriStr);
        if (isForward) {
            this.jsonProvider.removeProperty(fieldMetaData, "@reverse");
            this.jsonProvider.setProperty(fieldMetaData, "@id", iriValue);
        } else {
            this.jsonProvider.removeProperty(fieldMetaData, "@id");
            this.jsonProvider.setProperty(fieldMetaData, "@reverse", iriValue);
        }
    }

    public void declareNamespace(Object json, String prefix, String iri) {
        Object context = this.getOrCreateContext(json);
        this.jsonProvider.setProperty(context, prefix, iri);
    }

    public void getNamespaces(Object json) {
    }
}

