/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.json.graph;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import java.util.Iterator;
import org.aksw.commons.path.json.PathJson;
import org.aksw.commons.util.direction.Direction;
import org.aksw.jenax.arq.util.triple.TripleFilter;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.io.json.accumulator.AggJsonEdge;
import org.aksw.jenax.io.json.accumulator.AggJsonNode;
import org.aksw.jenax.io.json.accumulator.AggJsonProperty;
import org.aksw.jenax.io.json.graph.GraphToJsonEdgeMapper;
import org.aksw.jenax.io.json.graph.GraphToJsonMapperNode;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.util.iterator.ExtendedIterator;

public class GraphToJsonPropertyMapper
extends GraphToJsonEdgeMapper {
    protected boolean isUniqueLang = false;
    protected int maxCount = -1;
    protected boolean single = false;

    public GraphToJsonPropertyMapper(TripleFilter baseFilter) {
        super(baseFilter);
    }

    public static GraphToJsonPropertyMapper of(P_Path0 basicPath) {
        return GraphToJsonPropertyMapper.of(basicPath.getNode(), Direction.ofFwd((boolean)basicPath.isForward()));
    }

    public static GraphToJsonPropertyMapper of(Node node, boolean isForward) {
        return GraphToJsonPropertyMapper.of(node, Direction.ofFwd((boolean)isForward));
    }

    public static GraphToJsonPropertyMapper of(Node predicate, Direction direction) {
        TripleFilter baseFilter = TripleFilter.create((Node)Vars.s, (Node)predicate, (boolean)direction.isForward());
        return new GraphToJsonPropertyMapper(baseFilter);
    }

    public TripleFilter getBaseFilter() {
        return this.baseFilter;
    }

    public GraphToJsonPropertyMapper setBaseFilter(TripleFilter baseFilter) {
        this.baseFilter = baseFilter;
        return this;
    }

    @Override
    public GraphToJsonMapperNode getTargetNodeMapper() {
        return this.targetNodeMapper;
    }

    public GraphToJsonPropertyMapper setTargetNodeMapper(GraphToJsonMapperNode targetNodeMapper) {
        this.targetNodeMapper = targetNodeMapper;
        return this;
    }

    public Boolean isUniqueLang() {
        return this.isUniqueLang;
    }

    public GraphToJsonPropertyMapper setUniqueLang(boolean isUniqueLang) {
        this.isUniqueLang = isUniqueLang;
        return this;
    }

    public Integer getMaxCount() {
        return this.maxCount;
    }

    public GraphToJsonPropertyMapper setMaxCount(int maxCount) {
        this.maxCount = maxCount;
        return this;
    }

    public boolean isSingle() {
        return this.single;
    }

    public void setSingle(boolean single) {
        this.single = single;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonElement map(PathJson path, JsonArray errors, Graph graph, Node node) {
        int arraySize;
        JsonArray tmp = null;
        boolean isForward = this.baseFilter.isForward();
        TripleFilter filter = this.baseFilter.bindSource(node);
        if (filter != null) {
            Triple pattern = filter.getTriplePattern();
            ExtendedIterator it = graph.find(pattern);
            try {
                int i = 0;
                while (it.hasNext()) {
                    PathJson subPath = (PathJson)path.resolve((Object)PathJson.Step.of((int)i));
                    Triple triple = (Triple)it.next();
                    Boolean filterResult = filter.evalExpr(triple);
                    if (Boolean.TRUE.equals(filterResult)) {
                        Node o = TripleUtils.getTarget((Triple)triple, (boolean)isForward);
                        JsonElement contrib = this.targetNodeMapper.map(subPath, errors, graph, o);
                        if (tmp == null) {
                            tmp = new JsonArray();
                        }
                        tmp.add(contrib);
                    }
                    ++i;
                }
            }
            finally {
                Iter.close((Iterator)it);
            }
        }
        Object result = tmp == null ? JsonNull.INSTANCE : (this.isUniqueLang || this.maxCount == 1 || this.single ? ((arraySize = tmp.size()) == 0 ? JsonNull.INSTANCE : (arraySize == 1 ? tmp.get(0) : tmp)) : tmp);
        return result;
    }

    public String toString() {
        return "PropertyMapper [baseFilter=" + String.valueOf(this.baseFilter) + ", targetNodeMapper=" + String.valueOf(this.targetNodeMapper) + ", isUniqueLang=" + this.isUniqueLang + ", maxCount=" + this.maxCount + ", isHidden=" + this.isHidden + "]";
    }

    @Override
    public AggJsonEdge toAggregator(P_Path0 jsonKey) {
        AggJsonNode targetAgg = this.targetNodeMapper.toAggregator();
        if (this.baseFilter.getExprs() != null) {
            throw new UnsupportedOperationException("Expressions are not yet supported.");
        }
        Triple t = this.baseFilter.getTriplePattern();
        Node p = t.getPredicate();
        if (!p.isConcrete()) {
            throw new UnsupportedOperationException("Predicate must be concrete");
        }
        if (t.getSubject().isConcrete() || t.getObject().isConcrete()) {
            throw new UnsupportedOperationException("Subject and/or object must nont be variables");
        }
        boolean isForward = this.baseFilter.isForward();
        AggJsonProperty result = AggJsonProperty.of(jsonKey, p, isForward, targetAgg);
        result.setSingle(this.single);
        return result;
    }
}

