/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.json.graph;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import org.aksw.commons.path.json.PathJson;
import org.aksw.commons.util.direction.Direction;
import org.aksw.jenax.arq.util.triple.TripleFilter;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.io.json.accumulator.AggJsonFragmentHead;
import org.aksw.jenax.io.json.accumulator.AggJsonNode;
import org.aksw.jenax.io.json.graph.GraphToJsonEdgeMapper;
import org.aksw.jenax.io.json.graph.GraphToJsonNodeMapperFragmentBody;
import org.aksw.jenax.io.json.graph.GraphToJsonNodeMapperObjectLike;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.path.P_Path0;

public class GraphToJsonNodeMapperFragmentHead
extends GraphToJsonEdgeMapper {
    public GraphToJsonNodeMapperFragmentHead(TripleFilter baseFilter) {
        super(baseFilter);
        this.targetNodeMapper = new GraphToJsonNodeMapperFragmentBody();
    }

    public static GraphToJsonNodeMapperFragmentHead of(P_Path0 basicPath) {
        return GraphToJsonNodeMapperFragmentHead.of(basicPath.getNode(), Direction.ofFwd((boolean)basicPath.isForward()));
    }

    public static GraphToJsonNodeMapperFragmentHead of(Node node, boolean isForward) {
        return GraphToJsonNodeMapperFragmentHead.of(node, Direction.ofFwd((boolean)isForward));
    }

    public static GraphToJsonNodeMapperFragmentHead of(Node predicate, Direction direction) {
        TripleFilter baseFilter = TripleFilter.create((Node)Vars.s, (Node)predicate, (boolean)direction.isForward());
        return new GraphToJsonNodeMapperFragmentHead(baseFilter);
    }

    public TripleFilter getBaseFilter() {
        return this.baseFilter;
    }

    public GraphToJsonNodeMapperFragmentHead setBaseFilter(TripleFilter baseFilter) {
        this.baseFilter = baseFilter;
        return this;
    }

    @Override
    public GraphToJsonNodeMapperObjectLike getTargetNodeMapper() {
        return (GraphToJsonNodeMapperObjectLike)this.targetNodeMapper;
    }

    public GraphToJsonNodeMapperFragmentHead setTargetNodeMapper(GraphToJsonNodeMapperObjectLike targetNodeMapper) {
        this.targetNodeMapper = targetNodeMapper;
        return this;
    }

    @Override
    public JsonElement map(PathJson path, JsonArray errors, Graph graph, Node node) {
        throw new RuntimeException("Mapper for fragments not implemented");
    }

    public String toString() {
        return "PropertyMapper [baseFilter=" + String.valueOf(this.baseFilter) + ", targetNodeMapper=" + String.valueOf(this.targetNodeMapper) + "]";
    }

    @Override
    public AggJsonFragmentHead toAggregator(P_Path0 jsonKey) {
        AggJsonNode targetAgg = this.targetNodeMapper.toAggregator();
        if (this.baseFilter.getExprs() != null) {
            throw new UnsupportedOperationException("Expressions are not yet supported.");
        }
        Triple t = this.baseFilter.getTriplePattern();
        Node p = t.getPredicate();
        if (!p.isConcrete()) {
            throw new UnsupportedOperationException("Predicate must be concrete");
        }
        if (t.getSubject().isConcrete() || t.getObject().isConcrete()) {
            throw new UnsupportedOperationException("Subject and/or object must nont be variables");
        }
        boolean isForward = this.baseFilter.isForward();
        AggJsonFragmentHead result = AggJsonFragmentHead.of(jsonKey, p, isForward, targetAgg);
        return result;
    }
}

