/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.json.accumulator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.aksw.jenax.io.json.accumulator.AccContextRdf;
import org.aksw.jenax.io.json.accumulator.AccJsonDriver;
import org.aksw.jenax.io.json.accumulator.AggJsonLiteral;
import org.aksw.jenax.io.json.accumulator.AggJsonObject;
import org.aksw.jenax.io.json.accumulator.AggJsonProperty;
import org.aksw.jenax.io.json.writer.RdfObjectNotationWriterViaJson;
import org.aksw.jenax.ron.RdfArrayImpl;
import org.aksw.jenax.ron.RdfElementVisitorRdfToJson;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.core.Quad;

public class EdgeBasedAccumulator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        AggJsonObject movieObject = new AggJsonObject();
        AggJsonProperty actorEdge = AggJsonProperty.of(NodeFactory.createLiteral((String)"actor"), NodeFactory.createURI((String)"urn:actor"), true);
        movieObject.addPropertyAggregator(actorEdge);
        AggJsonObject actorObject = new AggJsonObject();
        actorEdge.setTargetAgg(actorObject);
        AggJsonProperty actorLabelEdge = AggJsonProperty.of(NodeFactory.createLiteral((String)"label"), NodeFactory.createURI((String)"urn:actorLabel"), true);
        actorLabelEdge.setSingle(true);
        AggJsonLiteral actorLabelValue = new AggJsonLiteral();
        actorLabelEdge.setTargetAgg(actorLabelValue);
        actorObject.addPropertyAggregator(actorLabelEdge);
        AggJsonProperty moveLabelEdge = AggJsonProperty.of(NodeFactory.createLiteral((String)"label"), NodeFactory.createURI((String)"urn:movieLabel"), true);
        movieObject.addPropertyAggregator(moveLabelEdge);
        AggJsonLiteral movieLabelValue = new AggJsonLiteral();
        moveLabelEdge.setTargetAgg(movieLabelValue);
        List<Quad> data = Arrays.asList(EdgeBasedAccumulator.create("urn:movie0", "urn:movie0", null, null), EdgeBasedAccumulator.create("urn:movie0", "urn:movie0", "urn:movieLabel", "urn:movie[0].label[0]"), EdgeBasedAccumulator.create("urn:movie1", "urn:movie1", null, null), EdgeBasedAccumulator.create("urn:movie1", "urn:movie1", "urn:actor", "urn:actor1"), EdgeBasedAccumulator.create("urn:movie1", "urn:actor1", "urn:actorLabel", "urn:actor[1].label[0]"), EdgeBasedAccumulator.create("urn:movie1", "urn:actor1", "urn:actorLabel", "urn:actor[1].label[1]"), EdgeBasedAccumulator.create("urn:movie1", "urn:movie1", "urn:movieLabel", "urn:movie[1].label[0]"), EdgeBasedAccumulator.create("urn:movie1", "urn:movie1", "urn:movieLabel", "urn:movie[1].label[1]"), EdgeBasedAccumulator.create("urn:movie2", "urn:movie2", null, null), EdgeBasedAccumulator.create("urn:movie2", "urn:movie2", "urn:actor", "urn:actor2"), EdgeBasedAccumulator.create("urn:movie2", "urn:actor2", "urn:actorLabel", "urn:actor[2].label[0]"));
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonWriter writer = gson.newJsonWriter((Writer)new OutputStreamWriter(System.out));
        AccContextRdf accContext = new AccContextRdf(new RdfObjectNotationWriterViaJson(gson, writer), true, true);
        accContext.setErrorHandler(ev -> System.err.println("Error: " + String.valueOf(ev)));
        accContext.materialize = true;
        RdfArrayImpl materialized = new RdfArrayImpl();
        try {
            writer.beginArray();
            AccJsonDriver driver = AccJsonDriver.of(movieObject.newAccumulator(), false);
            driver.asStream(accContext, data.stream()).map(Map.Entry::getValue).forEach(materialized::add);
            writer.endArray();
        }
        finally {
            writer.flush();
        }
        System.out.println();
        JsonElement trueJson = materialized.accept(new RdfElementVisitorRdfToJson());
        System.out.println("Materialized: " + gson.toJson(trueJson));
    }

    public static Quad create(String g, String s, String p, String o) {
        return Quad.create((Node)NodeFactory.createURI((String)g), (Node)NodeFactory.createURI((String)s), (Node)(p == null ? Node.ANY : NodeFactory.createURI((String)p)), (Node)(o == null ? Node.ANY : NodeFactory.createURI((String)o)));
    }
}

