/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.json.accumulator;

import org.aksw.jenax.io.json.accumulator.AccJsonEdge;
import org.aksw.jenax.io.json.accumulator.AccJsonNode;
import org.aksw.jenax.io.json.accumulator.AccJsonProperty;
import org.aksw.jenax.io.json.accumulator.AggJson;
import org.aksw.jenax.io.json.accumulator.AggJsonEdge;
import org.aksw.jenax.io.json.accumulator.AggJsonNode;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_Path0;

public class AggJsonProperty
implements AggJsonEdge {
    protected P_Path0 jsonKey;
    protected Node matchFieldId;
    protected boolean isForward;
    protected boolean isSingle = false;
    protected AggJsonNode targetAggregator;

    protected AggJsonProperty(P_Path0 jsonKey, Node matchFieldId, boolean isForward, AggJsonNode targetAggregator) {
        this.jsonKey = jsonKey;
        this.matchFieldId = matchFieldId;
        this.isForward = isForward;
        this.targetAggregator = targetAggregator;
    }

    public static AggJsonProperty of(Node jsonKey, Node matchFieldId, boolean isForward) {
        return AggJsonProperty.of((P_Path0)new P_Link(jsonKey), matchFieldId, isForward, null);
    }

    public static AggJsonProperty of(Node jsonKey, Node matchFieldId, boolean isForward, AggJsonNode targetAggregator) {
        return AggJsonProperty.of((P_Path0)new P_Link(jsonKey), matchFieldId, isForward, targetAggregator);
    }

    public static AggJsonProperty of(P_Path0 jsonKey, Node matchFieldId, boolean isForward) {
        return AggJsonProperty.of(jsonKey, matchFieldId, isForward, null);
    }

    public static AggJsonProperty of(P_Path0 jsonKey, Node matchFieldId, boolean isForward, AggJsonNode targetAggregator) {
        return new AggJsonProperty(jsonKey, matchFieldId, isForward, targetAggregator);
    }

    @Override
    public AccJsonEdge newAccumulator() {
        AccJsonNode valueAcc = this.targetAggregator.newAccumulator();
        AccJsonProperty result = new AccJsonProperty(this.jsonKey, this.matchFieldId, this.isForward, valueAcc, this.isSingle);
        valueAcc.setParent(result);
        return result;
    }

    @Override
    public Node getMatchFieldId() {
        return this.matchFieldId;
    }

    public P_Path0 getJsonKey() {
        return this.jsonKey;
    }

    public boolean isForward() {
        return this.isForward;
    }

    public AggJson getTargetAggregator() {
        return this.targetAggregator;
    }

    @Override
    public AggJsonProperty setTargetAgg(AggJsonNode targetAggregator) {
        this.targetAggregator = targetAggregator;
        return this;
    }

    public AggJsonProperty setSingle(boolean value) {
        this.isSingle = value;
        return this;
    }
}

