/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.json.accumulator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.aksw.commons.path.json.PathJson;
import org.aksw.jenax.io.json.accumulator.AccContextRdf;
import org.aksw.jenax.io.json.accumulator.AccJsonBase;
import org.aksw.jenax.io.json.accumulator.AccJsonEdge;
import org.aksw.jenax.io.json.accumulator.AccJsonObjectLike;
import org.aksw.jenax.ron.RdfElement;
import org.apache.jena.graph.Node;

public abstract class AccJsonObjectLikeBase
extends AccJsonBase
implements AccJsonObjectLike {
    protected Map<Node, Integer> fieldIdToIndex = new HashMap<Node, Integer>();
    protected AccJsonEdge[] edgeAccs = new AccJsonEdge[0];
    protected int currentFieldIndex = -1;
    protected AccJsonEdge currentFieldAcc = null;

    protected AccJsonObjectLikeBase(Map<Node, Integer> fieldIdToIndex, AccJsonEdge[] edgeAccs) {
        this.fieldIdToIndex = fieldIdToIndex;
        this.edgeAccs = edgeAccs;
    }

    @Override
    public PathJson getPath() {
        String stepName = this.currentFieldAcc == null ? "(no active field)" : Objects.toString(this.currentFieldAcc.getJsonKey());
        return (PathJson)(this.parent != null ? this.parent.getPath() : PathJson.newRelativePath((PathJson.Step[])new PathJson.Step[0])).resolve((Object)PathJson.Step.of((String)stepName));
    }

    public void addEdge(AccJsonEdge subAcc) {
        Node fieldId = subAcc.getMatchFieldId();
        int fieldIndex = this.edgeAccs.length;
        this.fieldIdToIndex.put(fieldId, fieldIndex);
        this.edgeAccs = Arrays.copyOf(this.edgeAccs, fieldIndex + 1);
        this.edgeAccs[fieldIndex] = subAcc;
        subAcc.setParent(this);
    }

    @Override
    public void acceptContribution(RdfElement value, AccContextRdf context) {
        throw new UnsupportedOperationException("This method should not be called on AccJsonNodeObjectLike. The AccJsonEdge implementations add their contributions directly to their parent.");
    }
}

