/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.json.accumulator;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.aksw.jenax.io.json.accumulator.AccContextRdf;
import org.aksw.jenax.io.json.accumulator.AccJson;
import org.aksw.jenax.io.json.accumulator.AccJsonEdge;
import org.aksw.jenax.io.json.accumulator.AccJsonObjectLikeBase;
import org.aksw.jenax.ron.RdfObjectImpl;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;

public class AccJsonObject
extends AccJsonObjectLikeBase {
    public AccJsonObject() {
        this(new HashMap<Node, Integer>(), new AccJsonEdge[0]);
    }

    protected AccJsonObject(Map<Node, Integer> fieldIdToIndex, AccJsonEdge[] edgeAccs) {
        super(fieldIdToIndex, edgeAccs);
    }

    public static AccJsonObject of(Map<Node, Integer> fieldIdToIndex, AccJsonEdge[] edgeAccs) {
        AccJsonObject result = new AccJsonObject(fieldIdToIndex, edgeAccs);
        for (AccJsonEdge acc : edgeAccs) {
            acc.setParent(result);
        }
        return result;
    }

    @Override
    public void begin(Node source, AccContextRdf context, boolean skipOutput) throws IOException {
        super.begin(source, context, skipOutput);
        this.currentFieldIndex = -1;
        this.currentFieldAcc = null;
        if (!skipOutput) {
            if (context.isMaterialize()) {
                this.value = new RdfObjectImpl(source);
            }
            if (context.isSerialize()) {
                context.getJsonWriter().beginObject();
            }
        }
    }

    @Override
    public AccJson transition(Triple input, AccContextRdf context) throws IOException {
        this.ensureBegun();
        Node inputFieldId = input.getPredicate();
        AccJson result = null;
        Integer inputFieldIndex = (Integer)this.fieldIdToIndex.get(inputFieldId);
        if (inputFieldIndex != null) {
            AccJsonEdge edgeAcc;
            Node inputSource;
            int requestedFieldIndex = inputFieldIndex;
            if (requestedFieldIndex < this.currentFieldIndex && Objects.equals(inputSource = TripleUtils.getSource((Triple)input, (boolean)(edgeAcc = this.edgeAccs[requestedFieldIndex]).isForward()), this.currentSourceNode)) {
                throw new RuntimeException("fields appear to have arrived out of order - should not happen");
            }
            for (int i = this.currentFieldIndex + 1; i < requestedFieldIndex; ++i) {
                AccJsonEdge edgeAcc2 = this.edgeAccs[i];
                edgeAcc2.begin(null, context, this.skipOutput);
                edgeAcc2.end(context);
            }
            this.currentFieldIndex = requestedFieldIndex;
            this.currentFieldAcc = this.edgeAccs[requestedFieldIndex];
            boolean isForward = this.currentFieldAcc.isForward();
            Node edgeInputSource = TripleUtils.getSource((Triple)input, (boolean)isForward);
            if (!Objects.equals(edgeInputSource, this.currentSourceNode)) {
                throw new RuntimeException("should not happen - node at " + String.valueOf(this.currentSourceNode) + " but edge claims " + String.valueOf(edgeInputSource));
            }
            this.currentFieldAcc.begin(edgeInputSource, context, this.skipOutput);
            result = this.currentFieldAcc.transition(input, context);
        }
        return result;
    }

    @Override
    public void end(AccContextRdf context) throws IOException {
        this.ensureBegun();
        for (int i = this.currentFieldIndex + 1; i < this.edgeAccs.length; ++i) {
            AccJsonEdge edgeAcc = this.edgeAccs[i];
            edgeAcc.begin(null, context, this.skipOutput);
            edgeAcc.end(context);
        }
        if (!this.skipOutput) {
            if (context.isMaterialize() && this.parent != null) {
                this.parent.acceptContribution(this.value, context);
            }
            if (context.isSerialize()) {
                context.getJsonWriter().endObject();
            }
        }
        this.currentFieldIndex = -1;
        this.currentFieldAcc = null;
        super.end(context);
    }

    public String toString() {
        return "AccJsonNodeObject (source: " + String.valueOf(this.currentSourceNode) + ", field: " + String.valueOf(this.currentFieldAcc) + ")";
    }
}

