/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.json.accumulator;

import java.io.IOException;
import java.util.Objects;
import org.aksw.commons.path.json.PathJson;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.aksw.jenax.io.json.accumulator.AccContextRdf;
import org.aksw.jenax.io.json.accumulator.AccJson;
import org.aksw.jenax.io.json.accumulator.AccJsonBase;
import org.aksw.jenax.io.json.accumulator.AccJsonEdge;
import org.aksw.jenax.io.json.accumulator.AccJsonNode;
import org.aksw.jenax.io.json.accumulator.AccJsonObject;
import org.aksw.jenax.ron.RdfElement;
import org.aksw.jenax.ron.RdfNull;
import org.aksw.jenax.ron.RdfObject;
import org.aksw.jenax.ron.RdfObjectImpl;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.path.P_Path0;

public class AccJsonFragmentHead
extends AccJsonBase
implements AccJsonEdge {
    protected Node matchFieldId;
    protected boolean isForward;
    protected P_Path0 dummyJsonKey;
    protected Node currentTarget = null;
    protected AccJsonNode targetAcc;
    protected boolean skipOutputStartedHere = false;
    protected long seenTargetCount = 0L;

    public AccJsonFragmentHead(P_Path0 dummyJsonKey, Node matchFieldId, boolean isForward, AccJsonNode targetAcc) {
        this.matchFieldId = matchFieldId;
        this.isForward = isForward;
        this.dummyJsonKey = dummyJsonKey;
        this.targetAcc = targetAcc;
    }

    @Override
    public PathJson getPath() {
        return (PathJson)(this.parent != null ? this.parent.getPath() : PathJson.newRelativePath((PathJson.Step[])new PathJson.Step[0])).resolve((Object)PathJson.Step.of((int)((int)this.seenTargetCount)));
    }

    @Override
    public P_Path0 getJsonKey() {
        return this.dummyJsonKey;
    }

    @Override
    public Node getMatchFieldId() {
        return this.matchFieldId;
    }

    @Override
    public void begin(Node node, AccContextRdf context, boolean skipOutput) throws IOException {
        super.begin(node, context, skipOutput);
        this.seenTargetCount = 0L;
        this.skipOutputStartedHere = false;
        if (!skipOutput && context.isMaterialize()) {
            this.value = new RdfObjectImpl(this.dummyJsonKey.getNode());
        }
    }

    @Override
    public AccJson transition(Triple input, AccContextRdf context) throws IOException {
        Node edgeInputSource;
        this.ensureBegun();
        AccJsonNode result = null;
        Node inputFieldId = input.getPredicate();
        if (this.matchFieldId.equals((Object)inputFieldId) && Objects.equals(this.currentSourceNode, edgeInputSource = TripleUtils.getSource((Triple)input, (boolean)true))) {
            ++this.seenTargetCount;
            this.currentTarget = TripleUtils.getTarget((Triple)input, (boolean)this.isForward);
            this.targetAcc.begin(this.currentTarget, context, this.skipOutput || this.skipOutputStartedHere);
            result = this.targetAcc;
        }
        return result;
    }

    @Override
    public void end(AccContextRdf context) throws IOException {
        this.ensureBegun();
        if (!this.skipOutput && context.isMaterialize() && this.parent != null) {
            RdfElement elt = this.value == null ? new RdfNull() : this.value;
            AccJson tmp = this.parent;
            while (true) {
                if (tmp instanceof AccJsonObject) break;
                AccJson accJson = this.parent;
                if (!(accJson instanceof AccJsonFragmentHead)) continue;
                AccJsonFragmentHead f = (AccJsonFragmentHead)accJson;
                tmp = f.parent;
            }
            AccJsonObject o = (AccJsonObject)tmp;
            AccJsonObject parentAcc = (AccJsonObject)tmp;
            boolean showFragments = false;
            if (showFragments) {
                parentAcc.value.getAsObject().addForward(this.dummyJsonKey.getNode(), elt);
            } else {
                parentAcc.value.getAsObject().getMembers().putAll(elt.getAsObject().getMembers());
            }
        }
        super.end(context);
    }

    public String toString() {
        return "Field(matches: " + String.valueOf(this.matchFieldId) + ", target: " + String.valueOf(this.currentTarget) + ", " + String.valueOf(this.targetAcc) + ")";
    }

    @Override
    public void acceptContribution(RdfElement item, AccContextRdf context) {
        this.ensureBegun();
        if (!this.skipOutput && context.isMaterialize()) {
            RdfObject src = item.getAsObject();
            RdfObject tgt = this.value.getAsObject();
            tgt.getMembers().putAll(src.getMembers());
        }
    }

    @Override
    public boolean isForward() {
        return this.isForward;
    }
}

