/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.ron;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import org.aksw.jenax.ron.RdfArray;
import org.aksw.jenax.ron.RdfElement;
import org.aksw.jenax.ron.RdfElementVisitor;
import org.aksw.jenax.ron.RdfLiteral;
import org.aksw.jenax.ron.RdfNull;
import org.aksw.jenax.ron.RdfObject;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.sparql.path.P_Path0;

public class RdfElementVisitorRdfToJsonNt
implements RdfElementVisitor<JsonElement> {
    @Override
    public JsonElement visit(RdfArray elements) {
        JsonArray result = new JsonArray();
        for (RdfElement item : elements) {
            JsonElement elt = item.accept(this);
            result.add(elt);
        }
        return result;
    }

    @Override
    public JsonElement visit(RdfObject obj) {
        JsonObject result = new JsonObject();
        for (Map.Entry<P_Path0, RdfElement> e : obj.getMembers().entrySet()) {
            P_Path0 path = e.getKey();
            Node key = path.getNode();
            boolean isFwd = path.isForward();
            Node id = obj.getExternalId();
            if (id != null) {
                result.addProperty("@id", NodeFmtLib.strNT((Node)id));
            }
            String name = (!isFwd ? "^" : "") + NodeFmtLib.strNT((Node)key);
            JsonElement elt = e.getValue().accept(this);
            result.add(name, elt);
        }
        return result;
    }

    @Override
    public JsonElement visit(RdfLiteral element) {
        Node node = element.getInternalId();
        JsonPrimitive result = new JsonPrimitive(NodeFmtLib.strNT((Node)node));
        return result;
    }

    @Override
    public JsonElement visit(RdfNull element) {
        return JsonNull.INSTANCE;
    }

    public static String path0ToName(P_Path0 path) {
        boolean isFwd = path.isForward();
        Node node = path.getNode();
        String name = (!isFwd ? "^" : "") + RdfElementVisitorRdfToJsonNt.getPlainString(node);
        return name;
    }

    public static String getPlainString(Node node) {
        return node == null ? "(null)" : (node.isURI() ? node.getURI() : (node.isBlank() ? node.getBlankNodeLabel() : (node.isLiteral() ? node.getLiteralLexicalForm() : node.toString())));
    }

    public static String path0ToNt(P_Path0 path) {
        boolean isFwd = path.isForward();
        Node node = path.getNode();
        String name = (!isFwd ? "^" : "") + NodeFmtLib.strNT((Node)node);
        return name;
    }

    public static JsonElement nodeToJsonElement(Node node) {
        JsonNull result;
        if (node == null) {
            result = JsonNull.INSTANCE;
        } else if (node.isURI()) {
            result = new JsonPrimitive(node.getURI());
        } else if (node.isLiteral()) {
            Object obj = node.getLiteralValue();
            if (obj instanceof JsonElement) {
                result = (JsonElement)obj;
            } else if ("https://w3id.org/aksw/norse#json".equals(node.getLiteralDatatypeURI())) {
                String lex = node.getLiteralLexicalForm();
                Gson gson = new Gson();
                try {
                    result = (JsonElement)gson.fromJson(lex, JsonElement.class);
                }
                catch (Exception e) {
                    result = new JsonPrimitive(lex);
                }
            } else if (obj instanceof String) {
                String value = (String)obj;
                result = new JsonPrimitive(value);
            } else if (obj instanceof Number) {
                Number value = (Number)obj;
                result = new JsonPrimitive(value);
            } else if (obj instanceof Boolean) {
                Boolean value = (Boolean)obj;
                result = new JsonPrimitive(value);
            } else {
                String value = node.getLiteralLexicalForm();
                result = new JsonPrimitive(value);
            }
        } else {
            result = node.isBlank() ? new JsonPrimitive(node.getBlankNodeLabel()) : new JsonPrimitive(node.toString());
        }
        return result;
    }
}

