/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.ron;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.aksw.jenax.ron.ParentLinkArray;
import org.aksw.jenax.ron.ParentLinkArrayImpl;
import org.aksw.jenax.ron.RdfArray;
import org.aksw.jenax.ron.RdfElement;
import org.aksw.jenax.ron.RdfElementNodeBase;
import org.aksw.jenax.ron.RdfElementVisitor;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;

public class RdfArrayImpl
extends RdfElementNodeBase
implements RdfArray {
    protected List<RdfElement> elements;

    public RdfArrayImpl() {
        this(NodeFactory.createBlankNode(), new ArrayList<RdfElement>());
    }

    protected RdfArrayImpl(Node node, List<RdfElement> elements) {
        super(node);
        this.elements = elements;
    }

    @Override
    public <T> T accept(RdfElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public RdfArray add(RdfElement element) {
        int i = this.elements.size();
        this.elements.add(element);
        ((RdfElementNodeBase)element).setParent(new ParentLinkArrayImpl(this, i));
        return this;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    public RdfArray addAll(RdfArray other) {
        other.forEach(this.elements::add);
        return this;
    }

    public RdfArray addAll(Collection<? extends RdfElement> c) {
        this.elements.addAll(c);
        return this;
    }

    @Override
    public RdfElement get(int index) {
        return this.elements.get(index);
    }

    @Override
    public Iterator<RdfElement> iterator() {
        return this.elements.iterator();
    }

    @Override
    public RdfArray set(int index, RdfElement element) {
        RdfElement elt = this.elements.get(index);
        if (elt != null) {
            RdfElementNodeBase x = (RdfElementNodeBase)elt;
            x.setParent(null);
            ((RdfElementNodeBase)element).setParent(new ParentLinkArrayImpl(this, index));
        }
        return this;
    }

    @Override
    public RdfArray remove(int index) {
        this.elements.remove(index);
        ListIterator<RdfElement> it = this.elements.listIterator(index);
        while (it.hasNext()) {
            RdfElementNodeBase elt = (RdfElementNodeBase)it.next();
            ParentLinkArray oldLink = elt.getParent().asArrayLink();
            elt.setParent(new ParentLinkArrayImpl(oldLink.getParent(), oldLink.getIndex() - 1));
        }
        return this;
    }
}

