/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.rdf.json;

import java.util.Map;
import org.aksw.commons.path.core.Path;
import org.aksw.jenax.io.rdf.json.Match;
import org.aksw.jenax.path.core.PathPP;
import org.aksw.jenax.ron.ParentLink;
import org.aksw.jenax.ron.ParentLinkArray;
import org.aksw.jenax.ron.ParentLinkObject;
import org.aksw.jenax.ron.RdfElement;
import org.aksw.jenax.ron.RdfObject;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.util.NodeFactoryExtra;

class UpSearch<T> {
    UpSearch() {
    }

    public static <T> Match<T> search(RdfElement start, Matcher<T> matcher) {
        PathPP path = PathPP.newRelativePath((P_Path0[])new P_Path0[0]);
        Match<T> result = UpSearch.search(start, path, matcher);
        return result;
    }

    public static <T> Match<T> search(RdfElement current, PathPP pathToOrigin, Matcher<T> matcher) {
        Match<T> result;
        T value = matcher.match(current, pathToOrigin);
        if (value != null) {
            result = new Match<T>(current, pathToOrigin, value);
        } else {
            Map.Entry<RdfObject, PathPP> nextSearch = UpSearch.getParentObject(current, pathToOrigin);
            if (nextSearch == null) {
                result = null;
            } else {
                RdfObject nextObj = nextSearch.getKey();
                PathPP nextPath = nextSearch.getValue();
                result = UpSearch.search(nextObj, nextPath, matcher);
            }
        }
        return result;
    }

    public static Map.Entry<RdfObject, PathPP> getParentObject(RdfElement elt) {
        return UpSearch.getParentObject(elt, PathPP.newRelativePath((P_Path0[])new P_Path0[0]));
    }

    public static Map.Entry<RdfObject, PathPP> getParentObject(RdfElement elt, PathPP relPath) {
        Map.Entry<RdfObject, PathPP> result;
        ParentLink link = elt.getParent();
        if (link == null) {
            result = null;
        } else if (link.isObjectLink()) {
            ParentLinkObject objLink = link.asObjectLink();
            PathPP nextPath = (PathPP)PathPP.newRelativePath((P_Path0)objLink.getKey()).resolve((Path)relPath);
            result = Map.entry(objLink.getParent(), nextPath);
        } else if (link.isArrayLink()) {
            ParentLinkArray arrLink = link.asArrayLink();
            PathPP segment = PathPP.newRelativePath((P_Path0)new P_Link(NodeFactoryExtra.intToNode((int)arrLink.getIndex())));
            PathPP nextPath = (PathPP)segment.resolve((Path)relPath);
            result = UpSearch.getParentObject(link.getParent(), nextPath);
        } else {
            throw new RuntimeException("Unknown link type: " + String.valueOf(link.getClass()));
        }
        return result;
    }

    static interface Matcher<T> {
        public T match(RdfElement var1, PathPP var2);
    }
}

