/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.rdf.json;

import org.aksw.jenax.ron.ParentLink;
import org.aksw.jenax.ron.RdfElement;
import org.aksw.jenax.ron.RdfObject;

public class JsonLdContext {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getNamespaceIri(RdfObject obj, String prefix) {
        RdfObject cxt = obj.getObject("@context");
        String result = null;
        if (cxt == null) return result;
        RdfElement elt = cxt.get(prefix);
        if (elt != null) {
            if (!elt.isLiteral()) throw new RuntimeException("not a literal");
            return elt.getAsLiteral().getInternalId().getLiteralLexicalForm();
        }
        RdfObject parentObj = JsonLdContext.getParentObject(obj);
        return JsonLdContext.getNamespaceIri(parentObj, prefix);
    }

    public static RdfObject getParentObject(RdfElement elt) {
        RdfObject result;
        ParentLink link = elt.getParent();
        if (link == null) {
            result = null;
        } else if (link.isObjectLink()) {
            result = link.asObjectLink().getParent();
        } else if (link.isArrayLink()) {
            result = JsonLdContext.getParentObject(link.getParent());
        } else {
            throw new RuntimeException("Unknown link type: " + String.valueOf(link.getClass()));
        }
        return result;
    }
}

