/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.json.graph;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import org.aksw.commons.path.json.PathJson;
import org.aksw.jenax.io.json.accumulator.AggJsonEdge;
import org.aksw.jenax.io.json.accumulator.AggJsonNode;
import org.aksw.jenax.io.json.accumulator.AggJsonObject;
import org.aksw.jenax.io.json.graph.GraphToJsonEdgeMapper;
import org.aksw.jenax.io.json.graph.GraphToJsonNodeMapperObjectLike;
import org.aksw.jenax.io.json.graph.GraphToJsonNodeMapperType;
import org.aksw.jenax.io.json.writer.RdfObjectNotationWriterViaJson;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.path.P_Path0;

public class GraphToJsonNodeMapperObject
extends GraphToJsonNodeMapperObjectLike {
    @Override
    public GraphToJsonNodeMapperType getType() {
        return GraphToJsonNodeMapperType.OBJECT;
    }

    @Override
    public JsonElement map(PathJson path, JsonArray errors, Graph graph, Node node) {
        JsonObject result = new JsonObject();
        for (Map.Entry<P_Path0, GraphToJsonEdgeMapper> e : this.getPropertyMappers().entrySet()) {
            P_Path0 keyNode = e.getKey();
            GraphToJsonEdgeMapper mapper = e.getValue();
            String name = RdfObjectNotationWriterViaJson.nodeToJsonKey(keyNode);
            PathJson subPath = (PathJson)path.resolve((Object)PathJson.Step.of((String)name));
            JsonElement contrib = mapper.map(subPath, errors, graph, node);
            if (mapper.isHidden()) {
                JsonObject toFlatten = null;
                if (contrib.isJsonArray()) {
                    JsonElement item;
                    JsonArray arr = contrib.getAsJsonArray();
                    if (arr.size() == 1 && (item = arr.get(0)).isJsonObject()) {
                        toFlatten = item.getAsJsonObject();
                    }
                } else if (contrib.isJsonObject()) {
                    toFlatten = contrib.getAsJsonObject();
                }
                if (toFlatten == null) continue;
                for (String key : toFlatten.keySet()) {
                    JsonElement value = toFlatten.get(key);
                    result.add(key, value);
                }
                continue;
            }
            result.add(name, contrib);
        }
        return result;
    }

    public String toString() {
        return "NodeMapperObject [propertyMappers=" + String.valueOf(this.propertyMappers) + "]";
    }

    @Override
    public AggJsonNode toAggregator() {
        AggJsonObject result = AggJsonObject.of(new AggJsonEdge[0]);
        this.propertyMappers.forEach((name, mapper) -> {
            P_Path0 node = name;
            AggJsonEdge agg = mapper.toAggregator(node);
            result.addPropertyAggregator(agg);
        });
        return result;
    }
}

