/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.json.graph;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.aksw.commons.path.json.PathJson;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.io.json.accumulator.AggJsonNode;
import org.aksw.jenax.io.json.graph.GraphToJsonMapperNode;
import org.aksw.jenax.io.json.graph.GraphToJsonNodeMapperLiteral;
import org.aksw.jenax.io.json.graph.GraphToJsonNodeMapperType;
import org.aksw.jenax.io.json.writer.RdfObjectNotationWriterViaJson;
import org.aksw.jenax.sparql.fragment.api.Fragment;
import org.aksw.jenax.sparql.fragment.impl.FragmentUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_Path0;

public class GraphToJsonIndexMapper
implements GraphToJsonMapperNode {
    protected Fragment fragment;
    protected Var sourceVar;
    protected Var indexVar;
    protected Map<P_Path0, Var> fieldToVar = new LinkedHashMap<P_Path0, Var>();
    protected Map<Var, GraphToJsonMapperNode> subMappers = new LinkedHashMap<Var, GraphToJsonMapperNode>();
    protected boolean skipIntermediateObject;

    public GraphToJsonIndexMapper(Fragment fragment, Var sourceVar, Var indexVar) {
        this.fragment = fragment;
        this.sourceVar = sourceVar;
        this.indexVar = indexVar;
    }

    public void addMapping(Var var, P_Path0 path, GraphToJsonMapperNode subMapper) {
        this.fieldToVar.put(path, var);
        this.subMappers.put(var, subMapper);
    }

    @Override
    public JsonElement map(PathJson path, JsonArray errors, Graph graph, Node node) {
        Objects.requireNonNull(node);
        DatasetGraph dsg = DatasetGraphFactory.wrap((Graph)graph);
        JsonObject result = new JsonObject();
        Query query = this.fragment.toQuery();
        QueryUtils.injectFilter((Query)query, (Var)this.sourceVar, (Node)node);
        try (QueryExec qe = QueryExec.dataset((DatasetGraph)dsg).query(query).build();){
            RowSet rs = qe.select();
            while (rs.hasNext()) {
                JsonArray arr;
                Binding b = rs.next();
                Node indexValue = b.get(this.indexVar);
                P_Link indexKey = new P_Link(indexValue);
                String indexName = RdfObjectNotationWriterViaJson.nodeToJsonKey((P_Path0)indexKey);
                JsonElement arrElt = result.get(indexName);
                if (arrElt == null) {
                    arr = new JsonArray();
                    result.add(indexName, (JsonElement)arr);
                } else {
                    arr = arrElt.getAsJsonArray();
                }
                JsonObject item = new JsonObject();
                for (Map.Entry<P_Path0, Var> e : this.fieldToVar.entrySet()) {
                    P_Path0 key = e.getKey();
                    String name = RdfObjectNotationWriterViaJson.nodeToJsonKey(key);
                    PathJson subPath = (PathJson)path.resolve((Object)PathJson.Step.of((String)name));
                    Var v = e.getValue();
                    Node subNode = b.get(v);
                    GraphToJsonMapperNode subMapper = this.subMappers.get(v);
                    JsonElement subElt = subMapper.map(subPath, errors, graph, subNode);
                    item.add(name, subElt);
                }
                arr.add((JsonElement)item);
            }
        }
        return result;
    }

    @Override
    public GraphToJsonNodeMapperType getType() {
        return GraphToJsonNodeMapperType.OBJECT;
    }

    @Override
    public AggJsonNode toAggregator() {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) {
        Query query = QueryFactory.create((String)"SELECT ?s ?p ?o ?x { ?s ?p ?o BIND(CONCAT('foo-', STR(?p)) AS ?x) }");
        Fragment fragment = FragmentUtils.fromQuery((Query)query);
        Graph graph = RDFParser.create().fromString("    PREFIX : <http://www.example.org/>\n\n    :s1 :p1 :o1 .\n    :s1 :p1 :o2 .\n    :s1 :p2 :o3 .\n\n    :s2 :p3 :o4 .\n").lang(Lang.TURTLE).toGraph();
        GraphToJsonIndexMapper mapper = new GraphToJsonIndexMapper(fragment, Vars.s, Vars.p);
        mapper.addMapping(Vars.o, (P_Path0)new P_Link(NodeFactory.createLiteralString((String)"myProperty")), GraphToJsonNodeMapperLiteral.get());
        mapper.addMapping(Vars.x, (P_Path0)new P_Link(NodeFactory.createLiteralString((String)"dummy")), GraphToJsonNodeMapperLiteral.get());
        JsonElement elt = mapper.map(PathJson.newAbsolutePath((PathJson.Step[])new PathJson.Step[0]), new JsonArray(), graph, NodeFactory.createURI((String)"http://www.example.org/s1"));
        String str = new GsonBuilder().setPrettyPrinting().create().toJson(elt);
        System.out.println(str);
    }
}

