/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.json.gon;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.aksw.jenax.io.json.gon.GonProvider;

public class GonProviderGson
implements GonProvider<String, JsonPrimitive> {
    protected Gson gson;

    protected GonProviderGson(Gson gson) {
        this.gson = gson;
    }

    public static GonProviderGson of() {
        return GonProviderGson.of(new GsonBuilder().setPrettyPrinting().setLenient().create());
    }

    public static GonProviderGson of(Gson gson) {
        Objects.requireNonNull(gson);
        return new GonProviderGson(gson);
    }

    @Override
    public Object parse(String str) {
        Object result = this.gson.fromJson(str, JsonElement.class);
        return result;
    }

    @Override
    public Object newObject() {
        return new JsonObject();
    }

    @Override
    public boolean isObject(Object obj) {
        return obj instanceof JsonObject;
    }

    protected static JsonElement asElement(Object obj) {
        JsonElement result = (JsonElement)obj;
        return result;
    }

    protected static JsonObject asObject(Object obj) {
        JsonObject result = GonProviderGson.asElement(obj).getAsJsonObject();
        return result;
    }

    protected static JsonArray asArray(Object obj) {
        JsonArray result = GonProviderGson.asElement(obj).getAsJsonArray();
        return result;
    }

    protected static JsonPrimitive asPrimitive(Object obj) {
        JsonPrimitive result = GonProviderGson.asElement(obj).getAsJsonPrimitive();
        return result;
    }

    @Override
    public void setProperty(Object obj, String key, Object value) {
        GonProviderGson.asObject(obj).add(key, GonProviderGson.asElement(value));
    }

    @Override
    public Object getProperty(Object obj, Object key) {
        return GonProviderGson.asObject(obj).get((String)key);
    }

    @Override
    public void removeProperty(Object obj, Object key) {
        GonProviderGson.asObject(obj).remove((String)key);
    }

    @Override
    public Iterator<Map.Entry<String, Object>> listProperties(Object obj) {
        return GonProviderGson.asObject(obj).entrySet().iterator();
    }

    @Override
    public Object newArray() {
        return new JsonArray();
    }

    @Override
    public boolean isArray(Object obj) {
        return obj instanceof JsonArray;
    }

    @Override
    public void addElement(Object arr, Object value) {
        GonProviderGson.asArray(arr).add(GonProviderGson.asElement(value));
    }

    @Override
    public void setElement(Object arr, int index, Object value) {
        GonProviderGson.asArray(arr).set(index, GonProviderGson.asElement(value));
    }

    @Override
    public void removeElement(Object arr, int index) {
        GonProviderGson.asArray(arr).remove(index);
    }

    @Override
    public Iterator<Object> listElements(Object arr) {
        return GonProviderGson.asArray(arr).iterator();
    }

    @Override
    public Object newLiteral(JsonPrimitive value) {
        return value;
    }

    @Override
    public boolean isLiteral(Object obj) {
        return obj instanceof JsonPrimitive;
    }

    @Override
    public JsonPrimitive getLiteral(Object obj) {
        return GonProviderGson.asPrimitive(obj);
    }

    @Override
    public Object newNull() {
        return JsonNull.INSTANCE;
    }

    @Override
    public boolean isNull(Object obj) {
        return GonProviderGson.asElement(obj).isJsonNull();
    }
}

