/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.json.accumulator;

import java.io.IOException;
import java.util.Objects;
import org.aksw.commons.path.json.PathJson;
import org.aksw.jenax.io.json.accumulator.AccContextRdf;
import org.aksw.jenax.io.json.accumulator.AccJson;
import org.aksw.jenax.io.json.accumulator.AccJsonBase;
import org.aksw.jenax.io.json.accumulator.AccJsonEdge;
import org.aksw.jenax.io.json.accumulator.AccJsonErrorEvent;
import org.aksw.jenax.io.json.accumulator.AccJsonErrorHandler;
import org.aksw.jenax.io.json.accumulator.AccJsonNode;
import org.aksw.jenax.io.json.accumulator.AccJsonObjectLikeBase;
import org.aksw.jenax.io.json.writer.RdfObjectNotationWriter;
import org.aksw.jenax.ron.RdfArrayImpl;
import org.aksw.jenax.ron.RdfElement;
import org.aksw.jenax.ron.RdfNull;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.path.P_Path0;

public class AccJsonProperty
extends AccJsonBase
implements AccJsonEdge {
    protected Node matchFieldId;
    protected boolean isForward;
    protected P_Path0 jsonKey;
    protected Node currentTarget = null;
    protected AccJsonNode targetAcc;
    protected boolean skipOutputStartedHere = false;
    protected long seenTargetCount = 0L;
    protected boolean isSingle = false;

    public AccJsonProperty(P_Path0 jsonKey, Node matchFieldId, boolean isForward, AccJsonNode targetAcc, boolean isSingle) {
        this.matchFieldId = matchFieldId;
        this.jsonKey = jsonKey;
        this.isForward = isForward;
        this.targetAcc = targetAcc;
        this.isSingle = isSingle;
    }

    @Override
    public PathJson getPath() {
        return (PathJson)(this.parent != null ? this.parent.getPath() : PathJson.newRelativePath((PathJson.Step[])new PathJson.Step[0])).resolve((Object)PathJson.Step.of((int)((int)this.seenTargetCount)));
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    @Override
    public P_Path0 getJsonKey() {
        return this.jsonKey;
    }

    @Override
    public Node getMatchFieldId() {
        return this.matchFieldId;
    }

    @Override
    public boolean isForward() {
        return this.isForward;
    }

    @Override
    public void begin(Node node, AccContextRdf context, boolean skipOutput) throws IOException {
        super.begin(node, context, skipOutput);
        this.seenTargetCount = 0L;
        this.skipOutputStartedHere = false;
        if (!skipOutput) {
            if (context.isMaterialize()) {
                RdfElement rdfElement = this.value = this.isSingle ? null : new RdfArrayImpl();
            }
            if (context.isSerialize()) {
                RdfObjectNotationWriter writer = context.getJsonWriter();
                writer.name(this.jsonKey);
                if (!this.isSingle) {
                    writer.beginArray();
                }
            }
        }
    }

    @Override
    public AccJson transition(Triple input, AccContextRdf context) throws IOException {
        this.ensureBegun();
        Node s = input.getSubject();
        Node p = input.getPredicate();
        Node o = input.getObject();
        AccJsonNode result = null;
        Node inputFieldId = p;
        if (this.matchFieldId.equals((Object)inputFieldId)) {
            Node edgeInputSource;
            Node node = edgeInputSource = this.isForward ? s : o;
            if (Objects.equals(this.currentSourceNode, edgeInputSource)) {
                boolean isTooMany;
                ++this.seenTargetCount;
                boolean bl = isTooMany = this.isSingle && this.seenTargetCount > 1L;
                if (isTooMany) {
                    this.skipOutputStartedHere = true;
                    AccJsonErrorHandler errorHandler = context.getErrorHandler();
                    if (errorHandler != null) {
                        PathJson path = this.getPath();
                        errorHandler.accept(new AccJsonErrorEvent(path, "Multiple values encountered for a field that was declared to have at most a single one."));
                    }
                }
                this.currentTarget = this.isForward ? o : s;
                this.targetAcc.begin(this.currentTarget, context, this.skipOutput || this.skipOutputStartedHere);
                result = this.targetAcc;
            }
        }
        return result;
    }

    @Override
    public void end(AccContextRdf context) throws IOException {
        this.ensureBegun();
        if (!this.skipOutput) {
            if (context.isMaterialize() && this.parent != null) {
                RdfElement elt = this.value == null ? new RdfNull() : this.value;
                AccJsonObjectLikeBase acc = (AccJsonObjectLikeBase)this.parent;
                acc.value.getAsObject().getMembers().put(this.jsonKey, elt);
            }
            if (context.isSerialize()) {
                RdfObjectNotationWriter jsonWriter = context.getJsonWriter();
                if (!this.isSingle) {
                    jsonWriter.endArray();
                } else if (this.seenTargetCount == 0L) {
                    jsonWriter.nullValue();
                }
            }
        }
        super.end(context);
    }

    public String toString() {
        return "Field(matches: " + String.valueOf(this.matchFieldId) + ", target: " + String.valueOf(this.currentTarget) + ", " + String.valueOf(this.targetAcc) + ")";
    }

    @Override
    public void acceptContribution(RdfElement item, AccContextRdf context) {
        this.ensureBegun();
        if (!this.skipOutput && context.isMaterialize()) {
            if (this.isSingle) {
                if (this.value == null) {
                    this.value = item;
                }
            } else {
                this.value.getAsArray().add(item);
            }
        }
    }
}

