/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.json.accumulator;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.aksw.jenax.io.json.accumulator.AccContextRdf;
import org.aksw.jenax.io.json.accumulator.AccJson;
import org.aksw.jenax.ron.RdfElement;
import org.apache.jena.graph.Node;

public abstract class AccJsonBase
implements AccJson {
    protected AccJson parent;
    protected RdfElement value = null;
    protected Node oldSourceNode;
    protected boolean hasBegun = false;
    protected Node currentSourceNode;
    protected boolean skipOutput = false;

    public void ensureBegun() {
        Preconditions.checkState((this.hasBegun ? 1 : 0) != 0);
    }

    @Override
    public void setParent(AccJson parent) {
        Preconditions.checkArgument((this.parent == null ? 1 : 0) != 0, (Object)"Parent already set");
        this.parent = parent;
    }

    @Override
    public AccJson getParent() {
        return this.parent;
    }

    @Override
    public RdfElement getValue() {
        if (this.hasBegun) {
            throw new IllegalStateException("getValue() must only be called after end()");
        }
        return this.value;
    }

    @Override
    public RdfElement getInternalValue() {
        return this.value;
    }

    @Override
    public void begin(Node sourceNode, AccContextRdf cxt, boolean skipOutput) throws IOException {
        if (this.hasBegun) {
            throw new IllegalStateException("begin() has already been called() with " + String.valueOf(this.currentSourceNode));
        }
        this.hasBegun = true;
        this.currentSourceNode = sourceNode;
        this.skipOutput = skipOutput;
    }

    @Override
    public void end(AccContextRdf cxt) throws IOException {
        this.oldSourceNode = this.currentSourceNode;
        this.currentSourceNode = null;
        this.hasBegun = false;
    }

    @Override
    public boolean hasBegun() {
        return this.hasBegun;
    }
}

