/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.json.writer;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.aksw.jenax.io.json.gon.GonProvider;
import org.aksw.jenax.io.json.writer.ObjectNotationWriter;

public class ObjectNotationWriterUtils {
    public static <K, V> void sendToWriter(ObjectNotationWriter<K, V> writer, GonProvider<K, V> provider, Object obj) throws IOException {
        if (provider.isObject(obj)) {
            writer.beginObject();
            Iterator<Map.Entry<K, Object>> it = provider.listProperties(obj);
            while (it.hasNext()) {
                Map.Entry<K, Object> e = it.next();
                K inKey = e.getKey();
                Object value = e.getValue();
                writer.name(inKey);
                ObjectNotationWriterUtils.sendToWriter(writer, provider, value);
            }
            writer.endObject();
        } else if (provider.isArray(obj)) {
            writer.beginArray();
            Iterator<Object> it = provider.listElements(obj);
            while (it.hasNext()) {
                Object element = it.next();
                ObjectNotationWriterUtils.sendToWriter(writer, provider, element);
            }
            writer.endArray();
        } else if (provider.isLiteral(obj)) {
            V inValue = provider.getLiteral(obj);
            writer.value(inValue);
        } else if (provider.isNull(obj)) {
            writer.value(null);
        } else {
            throw new IllegalArgumentException("Provider could not handle argument: " + String.valueOf(obj));
        }
    }
}

