/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.json.accumulator;

import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import org.aksw.jenax.io.json.accumulator.AccContextRdf;
import org.aksw.jenax.io.json.accumulator.AccJsonErrorHandler;
import org.aksw.jenax.io.json.gon.GonProvider;
import org.aksw.jenax.io.json.writer.ObjectNotationWriter;
import org.aksw.jenax.io.json.writer.RdfObjectNotationWriter;
import org.aksw.jenax.io.json.writer.RdfObjectNotationWriterViaJson;

public class AccContext<K, V> {
    protected boolean materialize;
    protected boolean serialize;
    protected ObjectNotationWriter<K, V> writer;
    protected GonProvider<K, V> gonProvider;
    protected AccJsonErrorHandler errorHandler = null;

    public AccContext(ObjectNotationWriter<K, V> writer, boolean materialize, boolean serialize) {
        this.writer = writer;
        this.materialize = materialize;
        this.serialize = serialize;
    }

    public static AccContextRdf materializing() {
        return new AccContextRdf(null, true, false);
    }

    public static AccContextRdf serializing(Gson gson, JsonWriter jsonWriter) {
        RdfObjectNotationWriterViaJson writer = new RdfObjectNotationWriterViaJson(gson, jsonWriter);
        return AccContext.serializing(writer);
    }

    public static AccContextRdf serializing(RdfObjectNotationWriter writer) {
        return new AccContextRdf(writer, false, true);
    }

    public static <K, V> AccContext<K, V> serializing(ObjectNotationWriter<K, V> writer) {
        return new AccContext<K, V>(writer, false, true);
    }

    public void setWriter(ObjectNotationWriter<K, V> writer) {
        this.writer = writer;
    }

    public void setErrorHandler(AccJsonErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public AccJsonErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public boolean isMaterialize() {
        return this.materialize;
    }

    public boolean isSerialize() {
        return this.serialize;
    }

    public ObjectNotationWriter<K, V> getJsonWriter() {
        return this.writer;
    }

    public GonProvider<K, V> getGonProvider() {
        return this.gonProvider;
    }

    public void setGonProvider(GonProvider<K, V> gonProvider) {
        this.gonProvider = gonProvider;
    }
}

