/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.ron;

import com.google.common.collect.Streams;
import java.util.stream.Stream;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.aksw.jenax.ron.RdfArray;
import org.aksw.jenax.ron.RdfElement;
import org.aksw.jenax.ron.RdfElementNodeBase;
import org.aksw.jenax.ron.RdfObject;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.path.P_Path0;

public class RdfElementToGraph {
    public static Graph toGraph(RdfElement elt) {
        Graph result = GraphFactory.createDefaultGraph();
        RdfElementToGraph.toGraph(result, elt);
        return result;
    }

    public static Graph toGraph(Graph dest, RdfElement elt) {
        RdfElementToGraph.streamEffectiveTriples(elt).forEach(arg_0 -> ((Graph)dest).add(arg_0));
        return dest;
    }

    public static Model toModel(RdfElement elt) {
        Model result = ModelFactory.createDefaultModel();
        RdfElementToGraph.toGraph(result.getGraph(), elt);
        return result;
    }

    public static Model toModel(Model dest, RdfElement elt) {
        Graph g = dest.getGraph();
        RdfElementToGraph.streamEffectiveTriples(elt).forEach(arg_0 -> ((Graph)g).add(arg_0));
        return dest;
    }

    public static Stream<Triple> streamEffectiveTriples(RdfElement element) {
        Stream<Object> result = element.isObject() ? RdfElementToGraph.streamEffectiveTriples_Object(element.getAsObject()) : (element.isArray() ? RdfElementToGraph.streamEffectiveTriples_Array(element.getAsArray()) : Stream.empty());
        return result;
    }

    public static Stream<Triple> streamEffectiveTriples_Array(RdfArray element) {
        return Streams.stream((Iterable)element).flatMap(RdfElementToGraph::streamEffectiveTriples);
    }

    public static Stream<Triple> streamEffectiveTriples_Object(RdfObject element) {
        Node s = element.getInternalId();
        return element.getMembers().entrySet().stream().flatMap(member -> {
            Stream<Object> r;
            P_Path0 p = (P_Path0)member.getKey();
            RdfElement o = (RdfElement)member.getValue();
            if (o instanceof RdfElementNodeBase) {
                RdfElementNodeBase nb = (RdfElementNodeBase)o;
                Triple t = TripleUtils.create((Node)s, (P_Path0)p, (Node)nb.getInternalId());
                Stream<Triple> subStream = RdfElementToGraph.streamEffectiveTriples(o);
                r = Stream.concat(Stream.of(t), subStream);
            } else {
                r = Stream.empty();
            }
            return r;
        });
    }
}

