/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.json.accumulator;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.aksw.jenax.io.json.accumulator.AccJsonEdge;
import org.aksw.jenax.io.json.accumulator.AccJsonNode;
import org.aksw.jenax.io.json.accumulator.AccJsonObject;
import org.aksw.jenax.io.json.accumulator.AggJsonEdge;
import org.aksw.jenax.io.json.accumulator.AggJsonNode;
import org.apache.jena.graph.Node;

public class AggJsonObject
implements AggJsonNode {
    protected LinkedHashMap<Node, AggJsonEdge> propertyAggregators = new LinkedHashMap();

    public static AggJsonObject of(AggJsonEdge ... edgeAggregators) {
        AggJsonObject result = new AggJsonObject();
        for (AggJsonEdge agg : edgeAggregators) {
            result.addPropertyAggregator(agg);
        }
        return result;
    }

    public LinkedHashMap<Node, AggJsonEdge> getPropertyAggregators() {
        return this.propertyAggregators;
    }

    public void addPropertyAggregator(AggJsonEdge propertyAggregator) {
        Node matchFieldId = propertyAggregator.getMatchFieldId();
        this.propertyAggregators.put(matchFieldId, propertyAggregator);
    }

    @Override
    public AccJsonNode newAccumulator() {
        int n = this.propertyAggregators.size();
        HashMap<Node, Integer> fieldIdToIndex = new HashMap<Node, Integer>();
        AccJsonEdge[] edgeAccs = new AccJsonEdge[n];
        int fieldIndex = 0;
        for (Map.Entry<Node, AggJsonEdge> e : this.propertyAggregators.entrySet()) {
            Node fieldId = e.getKey();
            AggJsonEdge agg = e.getValue();
            AccJsonEdge acc = agg.newAccumulator();
            fieldIdToIndex.put(fieldId, fieldIndex);
            edgeAccs[fieldIndex] = acc;
            ++fieldIndex;
        }
        AccJsonObject result = AccJsonObject.of(fieldIdToIndex, edgeAccs);
        return result;
    }
}

